/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.docker;

import foundation.stack.docker.DockerDetector;
import foundation.stack.docker.DockerDownloader;
import foundation.stack.docker.DockerInstaller;
import foundation.stack.docker.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class BootstrapCommandLineWizard {
    public static void launch() throws Exception {
        if (BootstrapCommandLineWizard.requestInstallationConfirmation()) {
            BootstrapCommandLineWizard.downloadAndInstallDocker();
        }
    }

    private static boolean requestInstallationConfirmation() throws IOException {
        System.out.println(Messages.translate("consoleTitle"));
        System.out.println();
        System.out.println(Messages.translate("welcome"));
        System.out.println(Messages.translate("consoleMessage"));
        boolean response = BootstrapCommandLineWizard.getYesNoResponse();
        if (response) {
            return true;
        }
        System.out.println(Messages.translate("cancelMessage"));
        System.out.println();
        System.out.println(Messages.translate("cancelConfirmation"));
        response = BootstrapCommandLineWizard.getYesNoResponse();
        if (response) {
            return false;
        }
        return BootstrapCommandLineWizard.requestInstallationConfirmation();
    }

    private static boolean showInstallError() {
        System.out.println(Messages.translate("installErrorTitle"));
        System.out.println();
        System.out.println(Messages.translate("installErrorMessage"));
        System.out.println();
        System.out.println(Messages.translate("installErrorConfirmation"));
        return BootstrapCommandLineWizard.getYesNoResponse();
    }

    private static void downloadAndInstallDocker() throws Exception {
        System.out.println(Messages.translate("consoleInstalling"));
        int result = -1;
        try {
            File installScript = DockerDownloader.downloadDocker((workDone, totalWork) -> {}, () -> false);
            result = DockerInstaller.installDocker(installScript);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((result != 0 || !DockerDetector.isDockerInstalled()) && BootstrapCommandLineWizard.showInstallError()) {
            BootstrapCommandLineWizard.downloadAndInstallDocker();
            return;
        }
        System.out.println(Messages.translate("consoleSuccess"));
    }

    private static boolean getYesNoResponse() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String response = reader.readLine();
            return "y".equalsIgnoreCase(response) || "yes".equalsIgnoreCase(response);
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

