/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.docker;

import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import foundation.stack.docker.BootstrapCommandLineWizard;
import foundation.stack.docker.BootstrapWizard;
import foundation.stack.docker.DelegatingDockerClient;
import foundation.stack.docker.DockerClient;
import foundation.stack.docker.DockerDetector;
import foundation.stack.docker.DockerMachineClient;
import foundation.stack.docker.Os;
import java.net.InetAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger logger = LoggerFactory.getLogger(Bootstrap.class);

    public static DockerClient bootstrapAndConnect(String machine, boolean bypassInstallation) throws Exception {
        if (!bypassInstallation) {
            if (!DockerDetector.isDockerInstalled()) {
                boolean javaFxPresent = true;
                try {
                    Bootstrap.class.getClassLoader().loadClass("javafx.application.Application");
                }
                catch (ClassNotFoundException e) {
                    javaFxPresent = false;
                }
                if ((Os.getSystemOs() == Os.Windows || Os.getSystemOs() == Os.MacOS) && javaFxPresent) {
                    BootstrapWizard.launch();
                } else {
                    logger.debug("The environment does not support graphics, switching to headless");
                    BootstrapCommandLineWizard.launch();
                }
            } else {
                logger.debug("Docker is already installed");
            }
        } else {
            logger.debug("Requested to bypass docker installation");
        }
        if (DockerDetector.isDockerInstalled()) {
            if (Os.getSystemOs() == Os.Windows || Os.getSystemOs() == Os.MacOS) {
                DockerMachineClient machineClient = new DockerMachineClient();
                return machineClient.connect(machine);
            }
            return new DelegatingDockerClient(DockerClientBuilder.getInstance((DockerClientConfig.DockerClientConfigBuilder)DockerClientConfig.createDefaultConfigBuilder()).build(), InetAddress.getLocalHost().getHostAddress());
        }
        logger.debug("Docker is not installed, assuming java client is meant to be used..");
        logger.debug("Will be using defaults, use environment variables to override them if they don't suit. ");
        return new DelegatingDockerClient(DockerClientBuilder.getInstance((DockerClientConfig.DockerClientConfigBuilder)DockerClientConfig.createDefaultConfigBuilder()).build(), InetAddress.getLocalHost().getHostAddress());
    }

    public static DockerClient bootstrapAndConnect(String machine) throws Exception {
        return Bootstrap.bootstrapAndConnect(machine, false);
    }

    public static void main(String[] a) throws Exception {
        List containers = (List)Bootstrap.bootstrapAndConnect("test", false).listContainersCmd().exec();
        for (Container container : containers) {
            System.out.println(container.getId());
        }
    }
}

