package foundation.stack.docker;

import com.github.dockerjava.api.command.*;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Identifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

/**
 * @author Ravi Chodavarapu (rchodava@gmail.com)
 */
public class DelegatingDockerClient implements DockerClient {
    private final com.github.dockerjava.api.DockerClient wrapped;
    private final String hostIpAddress;

    DelegatingDockerClient(com.github.dockerjava.api.DockerClient wrapped, String hostIpAddress) {
        this.wrapped = wrapped;
        this.hostIpAddress = URI.create(hostIpAddress).getHost();
    }

    @Override
    public String getHostIpAddress() {
        return hostIpAddress;
    }

    @Override
    public AuthConfig authConfig() throws DockerException {
        return wrapped.authConfig();
    }

    @Override
    public AuthCmd authCmd() {
        return wrapped.authCmd();
    }

    @Override
    public InfoCmd infoCmd() {
        return wrapped.infoCmd();
    }

    @Override
    public PingCmd pingCmd() {
        return wrapped.pingCmd();
    }

    @Override
    public VersionCmd versionCmd() {
        return wrapped.versionCmd();
    }

    @Override
    public PullImageCmd pullImageCmd(String repository) {
        return wrapped.pullImageCmd(repository);
    }

    @Override
    public PushImageCmd pushImageCmd(String name) {
        return wrapped.pushImageCmd(name);
    }

    @Override
    public PushImageCmd pushImageCmd(Identifier identifier) {
        return wrapped.pushImageCmd(identifier);
    }

    @Override
    public CreateImageCmd createImageCmd(String repository, InputStream imageStream) {
        return wrapped.createImageCmd(repository, imageStream);
    }

    @Override
    public SearchImagesCmd searchImagesCmd(String term) {
        return wrapped.searchImagesCmd(term);
    }

    @Override
    public RemoveImageCmd removeImageCmd(String imageId) {
        return wrapped.removeImageCmd(imageId);
    }

    @Override
    public ListImagesCmd listImagesCmd() {
        return wrapped.listImagesCmd();
    }

    @Override
    public InspectImageCmd inspectImageCmd(String imageId) {
        return wrapped.inspectImageCmd(imageId);
    }

    @Override
    public SaveImageCmd saveImageCmd(String name) {
        return wrapped.saveImageCmd(name);
    }

    @Override
    public ListContainersCmd listContainersCmd() {
        return wrapped.listContainersCmd();
    }

    @Override
    public CreateContainerCmd createContainerCmd(String image) {
        return wrapped.createContainerCmd(image);
    }

    @Override
    public StartContainerCmd startContainerCmd(String containerId) {
        return wrapped.startContainerCmd(containerId);
    }

    @Override
    public ExecCreateCmd execCreateCmd(String containerId) {
        return wrapped.execCreateCmd(containerId);
    }

    @Override
    public InspectContainerCmd inspectContainerCmd(String containerId) {
        return wrapped.inspectContainerCmd(containerId);
    }

    @Override
    public RemoveContainerCmd removeContainerCmd(String containerId) {
        return wrapped.removeContainerCmd(containerId);
    }

    @Override
    public WaitContainerCmd waitContainerCmd(String containerId) {
        return wrapped.waitContainerCmd(containerId);
    }

    @Override
    public AttachContainerCmd attachContainerCmd(String containerId) {
        return wrapped.attachContainerCmd(containerId);
    }

    @Override
    public ExecStartCmd execStartCmd(String containerId) {
        return wrapped.execStartCmd(containerId);
    }

    @Override
    public InspectExecCmd inspectExecCmd(String execId) {
        return wrapped.inspectExecCmd(execId);
    }

    @Override
    public LogContainerCmd logContainerCmd(String containerId) {
        return wrapped.logContainerCmd(containerId);
    }

    @Override
    public CopyArchiveFromContainerCmd copyArchiveFromContainerCmd(String containerId, String resource) {
        return wrapped.copyArchiveFromContainerCmd(containerId, resource);
    }

    @Override
    @Deprecated
    public CopyFileFromContainerCmd copyFileFromContainerCmd(String containerId, String resource) {
        return wrapped.copyFileFromContainerCmd(containerId, resource);
    }

    @Override
    public CopyArchiveToContainerCmd copyArchiveToContainerCmd(String containerId) {
        return wrapped.copyArchiveToContainerCmd(containerId);
    }

    @Override
    public ContainerDiffCmd containerDiffCmd(String containerId) {
        return wrapped.containerDiffCmd(containerId);
    }

    @Override
    public StopContainerCmd stopContainerCmd(String containerId) {
        return wrapped.stopContainerCmd(containerId);
    }

    @Override
    public KillContainerCmd killContainerCmd(String containerId) {
        return wrapped.killContainerCmd(containerId);
    }

    @Override
    public UpdateContainerCmd updateContainerCmd(String containerId) {
        return wrapped.updateContainerCmd(containerId);
    }

    @Override
    public RestartContainerCmd restartContainerCmd(String containerId) {
        return wrapped.restartContainerCmd(containerId);
    }

    @Override
    public CommitCmd commitCmd(String containerId) {
        return wrapped.commitCmd(containerId);
    }

    @Override
    public BuildImageCmd buildImageCmd() {
        return wrapped.buildImageCmd();
    }

    @Override
    public BuildImageCmd buildImageCmd(File dockerFileOrFolder) {
        return wrapped.buildImageCmd(dockerFileOrFolder);
    }

    @Override
    public BuildImageCmd buildImageCmd(InputStream tarInputStream) {
        return wrapped.buildImageCmd(tarInputStream);
    }

    @Override
    public TopContainerCmd topContainerCmd(String containerId) {
        return wrapped.topContainerCmd(containerId);
    }

    @Override
    public TagImageCmd tagImageCmd(String imageId, String repository, String tag) {
        return wrapped.tagImageCmd(imageId, repository, tag);
    }

    @Override
    public PauseContainerCmd pauseContainerCmd(String containerId) {
        return wrapped.pauseContainerCmd(containerId);
    }

    @Override
    public UnpauseContainerCmd unpauseContainerCmd(String containerId) {
        return wrapped.unpauseContainerCmd(containerId);
    }

    @Override
    public EventsCmd eventsCmd() {
        return wrapped.eventsCmd();
    }

    @Override
    public StatsCmd statsCmd(String containerId) {
        return wrapped.statsCmd(containerId);
    }

    @Override
    public CreateVolumeCmd createVolumeCmd() {
        return wrapped.createVolumeCmd();
    }

    @Override
    public InspectVolumeCmd inspectVolumeCmd(String name) {
        return wrapped.inspectVolumeCmd(name);
    }

    @Override
    public RemoveVolumeCmd removeVolumeCmd(String name) {
        return wrapped.removeVolumeCmd(name);
    }

    @Override
    public ListVolumesCmd listVolumesCmd() {
        return wrapped.listVolumesCmd();
    }

    @Override
    public ListNetworksCmd listNetworksCmd() {
        return wrapped.listNetworksCmd();
    }

    @Override
    public InspectNetworkCmd inspectNetworkCmd() {
        return wrapped.inspectNetworkCmd();
    }

    @Override
    public CreateNetworkCmd createNetworkCmd() {
        return wrapped.createNetworkCmd();
    }

    @Override
    public RemoveNetworkCmd removeNetworkCmd(String networkId) {
        return wrapped.removeNetworkCmd(networkId);
    }

    @Override
    public ConnectToNetworkCmd connectToNetworkCmd() {
        return wrapped.connectToNetworkCmd();
    }

    @Override
    public DisconnectFromNetworkCmd disconnectFromNetworkCmd() {
        return wrapped.disconnectFromNetworkCmd();
    }

    @Override
    public void close() throws IOException {
        wrapped.close();
    }
}
