package foundation.stack.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * @author Ravi Chodavarapu (rchodava@gmail.com)
 */
public class BootstrapCommandLineWizard {

    public static void launch() throws Exception {
        if (requestInstallationConfirmation()) {
            downloadAndInstallDocker();
        }
    }

    private static boolean requestInstallationConfirmation() throws IOException {
        System.out.println(Messages.translate("consoleTitle"));
        System.out.println();

        System.out.println(Messages.translate("welcome"));
        System.out.println(Messages.translate("consoleMessage"));

        boolean response = getYesNoResponse();

        if (response) {
            return true;
        } else {
            System.out.println(Messages.translate("cancelMessage"));
            System.out.println();
            System.out.println(Messages.translate("cancelConfirmation"));

            response = getYesNoResponse();

            if (response) {
                return false;
            } else {
                return requestInstallationConfirmation();
            }
        }
    }

    private static boolean showInstallError() {
        System.out.println(Messages.translate("installErrorTitle"));
        System.out.println();
        System.out.println(Messages.translate("installErrorMessage"));
        System.out.println();
        System.out.println(Messages.translate("installErrorConfirmation"));

        return getYesNoResponse();
    }

    private static void downloadAndInstallDocker() throws Exception {
        System.out.println(Messages.translate("consoleInstalling"));

        int result = -1;
        try {
            File installScript = DockerDownloader.downloadDocker((workDone, totalWork) -> {}, () -> false);
            result = DockerInstaller.installDocker(installScript);
        } catch (IOException e) {
        }

        if (result != 0 || !DockerDetector.isDockerInstalled()) {
            if (showInstallError()) {
                downloadAndInstallDocker();
                return;
            }
        }

        System.out.println(Messages.translate("consoleSuccess"));
    }

    private static boolean getYesNoResponse() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String response = reader.readLine();
            return "y".equalsIgnoreCase(response) || "yes".equalsIgnoreCase(response);
        } catch (IOException e) {
        }
        return false;
    }
}
