/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.values;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;

public class Times {
    public static long toEpochMillis(Temporal temporal) {
        if (temporal instanceof LocalDate) {
            return ((LocalDate)temporal).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toInstant().toEpochMilli();
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toInstant().toEpochMilli();
        }
        throw new IllegalArgumentException("The specified temporal type is not supported!");
    }
}

