/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.values;

import foundation.stack.datamill.reflection.impl.TypeSwitch;
import foundation.stack.datamill.values.ReflectableValue;
import foundation.stack.datamill.values.Value;
import java.time.LocalDateTime;
import java.util.UnknownFormatConversionException;
import java.util.function.Function;

public class StringValue
implements ReflectableValue {
    private static final TypeSwitch<StringValue, String, Object> stringCastSwitch = new TypeSwitch<StringValue, String, Object>(){

        @Override
        protected Object caseBoolean(StringValue value1, String value2) {
            return value2 != null ? Boolean.valueOf(value1.asBoolean()) : null;
        }

        @Override
        protected Object caseByte(StringValue value1, String value2) {
            return value2 != null ? Byte.valueOf(value1.asByte()) : null;
        }

        @Override
        protected Object caseCharacter(StringValue value1, String value2) {
            return value2 != null ? Character.valueOf(value1.asCharacter()) : null;
        }

        @Override
        protected Object caseShort(StringValue value1, String value2) {
            return value2 != null ? Short.valueOf(value1.asShort()) : null;
        }

        @Override
        protected Object caseInteger(StringValue value1, String value2) {
            return value2 != null ? Integer.valueOf(value1.asInteger()) : null;
        }

        @Override
        protected Object caseLong(StringValue value1, String value2) {
            return value2 != null ? Long.valueOf(value1.asLong()) : null;
        }

        @Override
        protected Object caseFloat(StringValue value1, String value2) {
            return value2 != null ? Float.valueOf(value1.asFloat()) : null;
        }

        @Override
        protected Object caseDouble(StringValue value1, String value2) {
            return value2 != null ? Double.valueOf(value1.asDouble()) : null;
        }

        @Override
        protected Object caseLocalDateTime(StringValue value1, String value2) {
            return value2 != null ? value1.asLocalDateTime() : null;
        }

        @Override
        protected Object caseByteArray(StringValue value1, String value2) {
            return value2 != null ? value1.asByteArray() : null;
        }

        @Override
        protected Object defaultCase(StringValue value1, String value2) {
            return value1.asString();
        }
    };
    private String value;

    public StringValue(String value) {
        this.value = value;
    }

    private boolean isFalsy() {
        return "".equals(this.value) || "false".equals(this.value) || "null".equals(this.value) || "0".equals(this.value) || "undefined".equals(this.value) || "NaN".equals(this.value);
    }

    @Override
    public byte asByte() {
        return Byte.parseByte(this.value);
    }

    @Override
    public byte[] asByteArray() {
        return this.asString().getBytes();
    }

    @Override
    public boolean asBoolean() {
        return !this.isFalsy();
    }

    @Override
    public char asCharacter() {
        if (this.value.length() != 1) {
            throw new UnknownFormatConversionException("Unable to convert string to character!");
        }
        return this.value.charAt(0);
    }

    @Override
    public double asDouble() {
        return Double.parseDouble(this.value);
    }

    @Override
    public float asFloat() {
        return Float.parseFloat(this.value);
    }

    @Override
    public LocalDateTime asLocalDateTime() {
        return LocalDateTime.parse(this.value);
    }

    @Override
    public long asLong() {
        return Long.parseLong(this.value);
    }

    @Override
    public int asInteger() {
        return Integer.parseInt(this.value);
    }

    @Override
    public Object asObject(Class<?> type) {
        return stringCastSwitch.doSwitch(type, this, this.value);
    }

    @Override
    public short asShort() {
        return Short.parseShort(this.value);
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public boolean isBoolean() {
        return "true".equals(this.value) || "false".equals(this.value) || "1".equals(this.value) || "0".equals(this.value);
    }

    @Override
    public boolean isByte() {
        try {
            this.asByte();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isCharacter() {
        return this.value.length() == 1;
    }

    @Override
    public boolean isDouble() {
        try {
            this.asDouble();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isFloat() {
        try {
            this.asFloat();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isNumeric() {
        return this.isLong() || this.isFloat();
    }

    @Override
    public boolean isLong() {
        try {
            this.asLong();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isInteger() {
        try {
            this.asInteger();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isShort() {
        try {
            this.asShort();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public <T> T map(Function<Value, T> mapper) {
        return mapper.apply(this);
    }
}

