/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.security;

import foundation.stack.datamill.security.JsonKey;
import foundation.stack.datamill.security.JsonKeyPair;
import foundation.stack.datamill.security.KeyType;
import foundation.stack.datamill.security.SecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;

public class KeySet {
    private final List<JsonKey> keys = new ArrayList<JsonKey>();

    public KeySet(String keySetJson) {
        try {
            JsonWebKeySet keySet = new JsonWebKeySet(keySetJson);
            for (JsonWebKey key : keySet.getJsonWebKeys()) {
                if (key instanceof PublicJsonWebKey) {
                    this.keys.add(new JsonKeyPairImpl(key));
                    continue;
                }
                this.keys.add(new JsonKeyImpl(key));
            }
        }
        catch (JoseException e) {
            throw new SecurityException(e);
        }
    }

    public List<JsonKey> getKeys() {
        return this.keys;
    }

    private static class JsonKeyPairImpl
    extends JsonKeyImpl
    implements JsonKeyPair {
        public JsonKeyPairImpl(JsonWebKey key) {
            super(key);
            if (!(key instanceof PublicJsonWebKey)) {
                throw new IllegalArgumentException("Specified key does not consist of a key pair!");
            }
        }

        @Override
        public Key getPrivateKey() {
            return ((PublicJsonWebKey)this.key).getPrivateKey();
        }
    }

    private static class JsonKeyImpl
    implements JsonKey {
        protected final JsonWebKey key;

        public JsonKeyImpl(JsonWebKey key) {
            this.key = key;
        }

        @Override
        public KeyType getType() {
            switch (this.key.getKeyType()) {
                case "RSA": {
                    return KeyType.RSA;
                }
                case "oct": {
                    return KeyType.SYMMETRIC;
                }
            }
            return KeyType.UNSUPPORTED;
        }

        @Override
        public String getId() {
            return this.key.getKeyId();
        }

        @Override
        public Key getKey() {
            return this.key.getKey();
        }
    }
}

