/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.security;

import java.security.Key;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.ByteUtil;

public interface KeyGenerators {

    public static class RSA {
        public static void main(String[] arguments) throws Exception {
            RsaJsonWebKey key = RsaJwkGenerator.generateJwk((int)2048);
            key.setKeyId("k" + System.currentTimeMillis());
            System.out.println("Public & Private:");
            System.out.println(new JsonWebKeySet(new JsonWebKey[]{key}).toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
            System.out.println();
            System.out.println("Only Public:");
            System.out.println(new JsonWebKeySet(new JsonWebKey[]{key}).toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY));
        }
    }

    public static class Symmetric {
        public static void main(String[] arguments) throws Exception {
            byte[] bytes = ByteUtil.randomBytes((int)ByteUtil.byteLength((int)512));
            OctetSequenceJsonWebKey key = new OctetSequenceJsonWebKey((Key)new HmacKey(bytes));
            key.setKeyId("k" + System.currentTimeMillis());
            System.out.println(new JsonWebKeySet(new JsonWebKey[]{key}).toJson(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC));
        }
    }
}

