/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.security;

import foundation.stack.datamill.security.JsonKey;
import foundation.stack.datamill.security.JsonKeyPair;
import foundation.stack.datamill.security.JsonWebToken;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class JsonWebTokenVerificationBuilder
extends JsonWebToken.AbstractJsonWebTokenVerificationBuilder {
    private static final String BEARER_AUTHENTICATION_SCHEME = "Bearer ";
    private static final int SCHEME_IDENTIFIER_LENGTH = "Bearer ".length();
    private JwtConsumerBuilder builder = new JwtConsumerBuilder();

    public JsonWebTokenVerificationBuilder requiringExpirationTime() {
        this.builder.setRequireExpirationTime();
        return this;
    }

    public JsonWebTokenVerificationBuilder allowingClockSkewInSeconds(int seconds) {
        this.builder.setAllowedClockSkewInSeconds(seconds);
        return this;
    }

    public JsonWebTokenVerificationBuilder requiringSubject() {
        this.builder.setRequireSubject();
        return this;
    }

    public JsonWebTokenVerificationBuilder expectingSubject(String subject) {
        this.builder.setExpectedSubject(subject);
        return this;
    }

    public JsonWebTokenVerificationBuilder expectingIssuer(String issuer) {
        this.builder.setExpectedIssuer(issuer);
        return this;
    }

    public JsonWebTokenVerificationBuilder expectingAudience(String audience) {
        this.builder.setExpectedAudience(new String[]{audience});
        return this;
    }

    public JsonWebTokenVerificationBuilder expectingDefaults() {
        return this.requiringExpirationTime().allowingClockSkewInSeconds(30).requiringSubject();
    }

    public JsonWebTokenVerificationBuilder withVerificationKey(JsonKey key) {
        if (key instanceof JsonKeyPair) {
            this.builder.setVerificationKey(((JsonKeyPair)key).getPrivateKey());
        } else {
            this.builder.setVerificationKey(key.getKey());
        }
        return this;
    }

    public JsonWebToken verify(String jwt) {
        if (jwt != null && jwt.startsWith(BEARER_AUTHENTICATION_SCHEME)) {
            jwt = jwt.substring(SCHEME_IDENTIFIER_LENGTH);
        }
        return super.verify(this.builder, jwt);
    }
}

