/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.security;

import foundation.stack.datamill.json.JsonObject;
import foundation.stack.datamill.security.JsonKey;
import foundation.stack.datamill.security.JsonKeyPair;
import foundation.stack.datamill.security.JsonWebTokenVerificationBuilder;
import foundation.stack.datamill.security.SecurityException;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.lang.JoseException;

public class JsonWebToken {
    private JsonKey key;
    private final JwtClaims claims;

    public static JsonWebTokenVerificationBuilder buildVerification() {
        return new JsonWebTokenVerificationBuilder();
    }

    public JsonWebToken() {
        this.claims = new JwtClaims();
    }

    private JsonWebToken(JwtClaims claims) {
        this.claims = claims;
    }

    public JsonWebToken addClaim(String claimName, String value) {
        this.claims.setClaim(claimName, (Object)value);
        return this;
    }

    public String getClaim(String claimName) {
        try {
            return this.claims.getStringClaimValue(claimName);
        }
        catch (MalformedClaimException e) {
            throw new SecurityException(e);
        }
    }

    public JsonObject asJson() {
        return new JsonObject(this.claims.getClaimsMap());
    }

    public String encoded() {
        JsonWebSignature signature = new JsonWebSignature();
        signature.setPayload(this.claims.toJson());
        signature.setKeyIdHeaderValue(this.key.getId());
        switch (this.key.getType()) {
            case SYMMETRIC: {
                signature.setKey(this.key.getKey());
                signature.setAlgorithmHeaderValue("HS256");
                break;
            }
            case RSA: {
                signature.setKey(((JsonKeyPair)this.key).getPrivateKey());
                signature.setAlgorithmHeaderValue("RS256");
            }
        }
        try {
            return signature.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new SecurityException(e);
        }
    }

    public String getSubject() {
        try {
            return this.claims.getSubject();
        }
        catch (MalformedClaimException e) {
            throw new SecurityException(e);
        }
    }

    public JsonWebToken setDefaults() {
        this.setGeneratedJwtId();
        this.setIssuedAtToNow();
        this.setNotBeforeMinutesInThePast(2.0f);
        this.setExpirationTimeMinutesInTheFuture(10.0f);
        return this;
    }

    public JsonWebToken setExpirationTimeMinutesInTheFuture(float minutes) {
        this.claims.setExpirationTimeMinutesInTheFuture(minutes);
        return this;
    }

    public JsonWebToken setGeneratedJwtId() {
        this.claims.setGeneratedJwtId();
        return this;
    }

    public JsonWebToken setIssuedAtToNow() {
        this.claims.setIssuedAtToNow();
        return this;
    }

    public JsonWebToken setIssuer(String issuer) {
        this.claims.setIssuer(issuer);
        return this;
    }

    public JsonWebToken setJwtId(String jwtId) {
        this.claims.setJwtId(jwtId);
        return this;
    }

    public JsonWebToken setKey(JsonKey key) {
        this.key = key;
        return this;
    }

    public JsonWebToken setNotBeforeMinutesInThePast(float minutes) {
        this.claims.setNotBeforeMinutesInThePast(minutes);
        return this;
    }

    public JsonWebToken setSubject(String subject) {
        this.claims.setSubject(subject);
        return this;
    }

    protected static abstract class AbstractJsonWebTokenVerificationBuilder {
        protected AbstractJsonWebTokenVerificationBuilder() {
        }

        protected JsonWebToken verify(JwtConsumerBuilder builder, String jwt) {
            try {
                JwtClaims claims = builder.build().processToClaims(jwt);
                return new JsonWebToken(claims);
            }
            catch (InvalidJwtException e) {
                throw new SecurityException(e);
            }
        }
    }
}

