/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.reflection.impl;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.functions.Func3;

public abstract class TripleArgumentTypeSwitch<T1, T2, T3, R> {
    private final Map<Class<?>, Func3<T1, T2, T3, R>> cases = new ConcurrentHashMap();

    public TripleArgumentTypeSwitch() {
        this.cases.put(Boolean.TYPE, (v1, v2, v3) -> this.caseBoolean(v1, v2, v3));
        this.cases.put(Boolean.class, (v1, v2, v3) -> this.caseBooleanWrapper(v1, v2, v3));
        this.cases.put(Byte.TYPE, (v1, v2, v3) -> this.caseByte(v1, v2, v3));
        this.cases.put(Byte.class, (v1, v2, v3) -> this.caseByteWrapper(v1, v2, v3));
        this.cases.put(Character.TYPE, (v1, v2, v3) -> this.caseCharacter(v1, v2, v3));
        this.cases.put(Character.class, (v1, v2, v3) -> this.caseCharacterWrapper(v1, v2, v3));
        this.cases.put(Short.TYPE, (v1, v2, v3) -> this.caseShort(v1, v2, v3));
        this.cases.put(Short.class, (v1, v2, v3) -> this.caseShortWrapper(v1, v2, v3));
        this.cases.put(Integer.TYPE, (v1, v2, v3) -> this.caseInteger(v1, v2, v3));
        this.cases.put(Integer.class, (v1, v2, v3) -> this.caseIntegerWrapper(v1, v2, v3));
        this.cases.put(Long.TYPE, (v1, v2, v3) -> this.caseLong(v1, v2, v3));
        this.cases.put(Long.class, (v1, v2, v3) -> this.caseLongWrapper(v1, v2, v3));
        this.cases.put(Float.TYPE, (v1, v2, v3) -> this.caseFloat(v1, v2, v3));
        this.cases.put(Float.class, (v1, v2, v3) -> this.caseFloatWrapper(v1, v2, v3));
        this.cases.put(Double.TYPE, (v1, v2, v3) -> this.caseDouble(v1, v2, v3));
        this.cases.put(Double.class, (v1, v2, v3) -> this.caseDoubleWrapper(v1, v2, v3));
        this.cases.put(LocalDateTime.class, (v1, v2, v3) -> this.caseLocalDateTime(v1, v2, v3));
        this.cases.put(byte[].class, (v1, v2, v3) -> this.caseByteArray(v1, v2, v3));
    }

    protected abstract R caseBoolean(T1 var1, T2 var2, T3 var3);

    protected R caseBooleanWrapper(T1 value1, T2 value2, T3 value3) {
        return this.caseBoolean(value1, value2, value3);
    }

    protected abstract R caseByte(T1 var1, T2 var2, T3 var3);

    protected R caseByteWrapper(T1 value1, T2 value2, T3 value3) {
        return this.caseByte(value1, value2, value3);
    }

    protected abstract R caseCharacter(T1 var1, T2 var2, T3 var3);

    protected R caseCharacterWrapper(T1 value1, T2 value2, T3 value3) {
        return this.caseCharacter(value1, value2, value3);
    }

    protected abstract R caseShort(T1 var1, T2 var2, T3 var3);

    protected R caseShortWrapper(T1 value1, T2 value2, T3 value3) {
        return this.caseShort(value1, value2, value3);
    }

    protected abstract R caseInteger(T1 var1, T2 var2, T3 var3);

    protected R caseIntegerWrapper(T1 value1, T2 value2, T3 value3) {
        return this.caseInteger(value1, value2, value3);
    }

    protected abstract R caseLong(T1 var1, T2 var2, T3 var3);

    protected R caseLongWrapper(T1 value1, T2 value2, T3 value3) {
        return this.caseLong(value1, value2, value3);
    }

    protected abstract R caseFloat(T1 var1, T2 var2, T3 var3);

    protected R caseFloatWrapper(T1 value1, T2 value2, T3 value3) {
        return this.caseFloat(value1, value2, value3);
    }

    protected abstract R caseDouble(T1 var1, T2 var2, T3 var3);

    protected R caseDoubleWrapper(T1 value1, T2 value2, T3 value3) {
        return this.caseDouble(value1, value2, value3);
    }

    protected abstract R caseLocalDateTime(T1 var1, T2 var2, T3 var3);

    protected abstract R caseByteArray(T1 var1, T2 var2, T3 var3);

    protected abstract R defaultCase(T1 var1, T2 var2, T3 var3);

    public final R doSwitch(Class<?> type, T1 value1, T2 value2, T3 value3) {
        Func3<T1, T2, T3, R> typeCase = this.cases.get(type);
        if (typeCase != null) {
            return (R)typeCase.call(value1, value2, value3);
        }
        return this.defaultCase(value1, value2, value3);
    }
}

