/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.reflection.impl;

import com.google.common.base.CaseFormat;
import com.google.common.base.Defaults;
import com.sun.beans.TypeResolver;
import foundation.stack.datamill.reflection.Bean;
import foundation.stack.datamill.reflection.Member;
import foundation.stack.datamill.reflection.Method;
import foundation.stack.datamill.reflection.Outline;
import foundation.stack.datamill.reflection.Property;
import foundation.stack.datamill.reflection.ReflectionException;
import foundation.stack.datamill.reflection.impl.TripleArgumentTypeSwitch;
import foundation.stack.datamill.values.Value;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import org.atteo.evo.inflector.English;

public class OutlineImpl<T>
implements Outline<T> {
    private final TripleArgumentTypeSwitch<Property, T, Value, Void> propertySetterSwitch = new TripleArgumentTypeSwitch<Property, T, Value, Void>(){

        @Override
        protected Void caseBoolean(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asBoolean());
            return null;
        }

        @Override
        protected Void caseBooleanWrapper(Property value1, T value2, Value value3) {
            value1.set(value2, (Boolean)value3.asObject(Boolean.class));
            return null;
        }

        @Override
        protected Void caseByte(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asByte());
            return null;
        }

        @Override
        protected Void caseByteWrapper(Property value1, T value2, Value value3) {
            value1.set(value2, (Byte)value3.asObject(Byte.class));
            return null;
        }

        @Override
        protected Void caseCharacter(Property value1, T value2, Value value3) {
            value1.set(value2, Character.valueOf(value3.asCharacter()));
            return null;
        }

        @Override
        protected Void caseCharacterWrapper(Property value1, T value2, Value value3) {
            value1.set(value2, (Character)value3.asObject(Character.class));
            return null;
        }

        @Override
        protected Void caseShort(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asShort());
            return null;
        }

        @Override
        protected Void caseShortWrapper(Property value1, T value2, Value value3) {
            value1.set(value2, (Short)value3.asObject(Short.class));
            return null;
        }

        @Override
        protected Void caseInteger(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asInteger());
            return null;
        }

        @Override
        protected Void caseIntegerWrapper(Property value1, T value2, Value value3) {
            value1.set(value2, (Integer)value3.asObject(Integer.class));
            return null;
        }

        @Override
        protected Void caseLong(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asLong());
            return null;
        }

        @Override
        protected Void caseLongWrapper(Property value1, T value2, Value value3) {
            value1.set(value2, (Long)value3.asObject(Long.class));
            return null;
        }

        @Override
        protected Void caseFloat(Property value1, T value2, Value value3) {
            value1.set(value2, Float.valueOf(value3.asFloat()));
            return null;
        }

        @Override
        protected Void caseFloatWrapper(Property value1, T value2, Value value3) {
            value1.set(value2, (Float)value3.asObject(Float.class));
            return null;
        }

        @Override
        protected Void caseDouble(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asDouble());
            return null;
        }

        @Override
        protected Void caseDoubleWrapper(Property value1, T value2, Value value3) {
            value1.set(value2, (Double)value3.asObject(Double.class));
            return null;
        }

        @Override
        protected Void caseLocalDateTime(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asLocalDateTime());
            return null;
        }

        @Override
        protected Void caseByteArray(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asByteArray());
            return null;
        }

        @Override
        protected Void defaultCase(Property value1, T value2, Value value3) {
            value1.set(value2, value3.asString());
            return null;
        }
    };
    private static java.lang.reflect.Method OBJECT_GET_CLASS_METHOD;
    private final boolean camelCased;
    private final ThreadLocal<String> lastInvokedMethod = new ThreadLocal();
    private final T members;
    private Collection<Method> methods;
    private Map<String, Property> properties;

    private static String capitalize(String string) {
        if (string != null && string.length() > 0) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    private static java.lang.reflect.Method findMethod(Class<?> start, String methodName, int numberOfArguments, Class<?>[] arguments) {
        for (Class<?> clazz = start; clazz != null; clazz = clazz.getSuperclass()) {
            java.lang.reflect.Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Type[] parameters;
                java.lang.reflect.Method method = methods[i];
                if (method == null || !Modifier.isPublic(method.getModifiers()) || !method.getName().equals(methodName) || (parameters = method.getGenericParameterTypes()).length != numberOfArguments) continue;
                if (arguments != null) {
                    boolean differentParameterType = false;
                    if (numberOfArguments > 0) {
                        for (int j = 0; j < numberOfArguments; ++j) {
                            if (TypeResolver.erase(TypeResolver.resolveInClass(start, parameters[j])) == arguments[j]) continue;
                            differentParameterType = true;
                        }
                        if (differentParameterType) continue;
                    }
                }
                return method;
            }
        }
        Class<?>[] interfaces = start.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            java.lang.reflect.Method method = OutlineImpl.findMethod(interfaces[i], methodName, numberOfArguments, null);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static java.lang.reflect.Method getObjectGetClassMethod() {
        if (OBJECT_GET_CLASS_METHOD == null) {
            try {
                OBJECT_GET_CLASS_METHOD = Object.class.getMethod("getClass", new Class[0]);
            }
            catch (Exception e) {
                OBJECT_GET_CLASS_METHOD = null;
            }
        }
        return OBJECT_GET_CLASS_METHOD;
    }

    public OutlineImpl(T members, boolean camelCased) {
        this.members = members;
        ((Proxy)members).setHandler((MethodHandler)new OutlineMethodHandler());
        this.camelCased = camelCased;
    }

    @Override
    public String camelCasedName() {
        return this.typeName();
    }

    @Override
    public String camelCasedPluralName() {
        return English.plural((String)this.camelCasedName());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.getOutlinedClass().getAnnotation(annotationClass);
    }

    private Class<?> getOutlinedClass() {
        return this.members.getClass().getSuperclass();
    }

    private Map<String, Property> getProperties() {
        if (this.properties == null) {
            this.introspectProperties();
        }
        return this.properties;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        return this.getOutlinedClass().getAnnotation(annotationClass) != null;
    }

    private void introspectProperties() {
        this.properties = new HashMap<String, Property>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.getOutlinedClass());
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                if (OutlineImpl.getObjectGetClassMethod().equals(descriptor.getReadMethod())) continue;
                this.properties.put(this.camelCased ? descriptor.getName() : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, descriptor.getName()), new PropertyImpl(descriptor));
            }
        }
        catch (IntrospectionException e) {
            throw new ReflectionException(e);
        }
    }

    private Collection<Method> getMethods() {
        if (this.methods == null) {
            this.introspectMethods();
        }
        return this.methods;
    }

    private void introspectMethods() {
        this.methods = new ArrayList<Method>();
        try {
            java.lang.reflect.Method[] classMethods;
            for (java.lang.reflect.Method method : classMethods = this.getOutlinedClass().getMethods()) {
                this.methods.add(new Method(method));
            }
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public Collection<Method> methods() {
        return this.getMethods();
    }

    private String lastInvokedMemberName() {
        String method = this.lastInvokedMethod.get();
        if (method != null) {
            if (method.startsWith("get") || method.startsWith("set")) {
                return method.substring(3);
            }
            if (method.startsWith("is")) {
                return method.substring(2);
            }
        }
        return method;
    }

    @Override
    public Member member(Consumer<T> memberInvoker) {
        memberInvoker.accept(this.members);
        return new MemberImpl(this.lastInvokedMemberName());
    }

    @Override
    public String name() {
        return this.camelCased ? this.camelCasedName() : this.snakeCasedName();
    }

    @Override
    public String pluralName() {
        return English.plural((String)this.name());
    }

    @Override
    public Property property(Consumer<T> memberInvoker) {
        return this.getProperties().get(this.member(memberInvoker).name());
    }

    @Override
    public Collection<String> propertyNames() {
        return this.getProperties().keySet();
    }

    @Override
    public Collection<Property> properties() {
        return this.getProperties().values();
    }

    @Override
    public String snakeCasedName() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.typeName());
    }

    @Override
    public String snakeCasedPluralName() {
        return English.plural((String)this.snakeCasedName());
    }

    private String typeName() {
        Class<?> type = this.getOutlinedClass();
        if (type != null) {
            return type.getSimpleName();
        }
        return null;
    }

    @Override
    public Bean<T> wrap(T instance) {
        return new BeanImpl(instance);
    }

    private class OutlineMethodHandler
    implements MethodHandler {
        private OutlineMethodHandler() {
        }

        public Object invoke(Object self, java.lang.reflect.Method thisMethod, java.lang.reflect.Method proceed, Object[] args) throws Throwable {
            OutlineImpl.this.lastInvokedMethod.set(thisMethod.getName());
            return Defaults.defaultValue(thisMethod.getReturnType());
        }
    }

    private class MemberImpl
    implements Member {
        private String memberName;

        public MemberImpl(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public String camelCasedName() {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.memberName);
        }

        @Override
        public String snakeCasedName() {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.memberName);
        }

        @Override
        public String name() {
            return OutlineImpl.this.camelCased ? this.camelCasedName() : this.snakeCasedName();
        }

        @Override
        public Outline<?> outline() {
            return OutlineImpl.this;
        }
    }

    private class PropertyImpl<T>
    extends MemberImpl
    implements Property<T> {
        private final PropertyDescriptor descriptor;
        private final java.lang.reflect.Method writeMethod;

        public PropertyImpl(PropertyDescriptor descriptor) {
            super(descriptor.getName());
            this.descriptor = descriptor;
            this.writeMethod = this.introspectWriteMethod(descriptor);
        }

        private java.lang.reflect.Method introspectWriteMethod(PropertyDescriptor descriptor) {
            java.lang.reflect.Method method = descriptor.getWriteMethod();
            if (method == null) {
                Class[] classArray;
                Class<?> cls = descriptor.getReadMethod().getDeclaringClass();
                Class<?> type = descriptor.getPropertyType();
                String writeMethodName = "set" + OutlineImpl.capitalize(descriptor.getName());
                if (type == null) {
                    classArray = null;
                } else {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = type;
                }
                Class[] args = classArray;
                method = OutlineImpl.findMethod(cls, writeMethodName, 1, args);
            }
            return method;
        }

        @Override
        public boolean isReadOnly() {
            return this.writeMethod == null;
        }

        @Override
        public boolean isSimple() {
            Class<?> propertyType = this.descriptor.getPropertyType();
            return propertyType.isPrimitive() || propertyType.isEnum() || propertyType == String.class;
        }

        @Override
        public Class<?> type() {
            return this.descriptor.getPropertyType();
        }

        private <T> T performSecureGet(Callable<T> runnable) {
            if (System.getSecurityManager() != null) {
                return (T)AccessController.doPrivileged(() -> {
                    try {
                        return runnable.call();
                    }
                    catch (Exception e) {
                        throw new ReflectionException(e);
                    }
                });
            }
            try {
                return runnable.call();
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }

        private void performSecure(Runnable runnable) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(() -> {
                    runnable.run();
                    return null;
                });
            } else {
                runnable.run();
            }
        }

        @Override
        public <P> P get(T instance) {
            java.lang.reflect.Method readMethod = this.descriptor.getReadMethod();
            if (readMethod != null) {
                if (!readMethod.isAccessible()) {
                    this.performSecure(() -> readMethod.setAccessible(true));
                }
                return (P)this.performSecureGet(() -> {
                    try {
                        return readMethod.invoke(instance, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw new ReflectionException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ReflectionException(e);
                    }
                });
            }
            throw new ReflectionException("Property does not have a getter!");
        }

        @Override
        public <P> void set(T instance, P value) {
            if (this.writeMethod != null) {
                if (!this.writeMethod.isAccessible()) {
                    this.performSecure(() -> this.writeMethod.setAccessible(true));
                }
                this.performSecure(() -> {
                    try {
                        this.writeMethod.invoke(instance, value);
                    }
                    catch (InvocationTargetException e) {
                        throw new ReflectionException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ReflectionException(e);
                    }
                });
            }
        }
    }

    private class BeanImpl
    implements Bean<T> {
        private final T instance;

        public BeanImpl(T instance) {
            this.instance = instance;
        }

        @Override
        public <P> P get(Consumer<T> propertyInvoker) {
            return OutlineImpl.this.property(propertyInvoker).get(this.instance);
        }

        @Override
        public <R, A1> R invoke(Method method, A1 argument) {
            return method.invoke(this.instance, argument);
        }

        @Override
        public <R, A1, A2> R invoke(Method method, A1 argument1, A2 argument2) {
            return method.invoke(this.instance, argument1, argument2);
        }

        @Override
        public <R> R invoke(Method method, Object ... arguments) {
            return method.invoke(this.instance, arguments);
        }

        @Override
        public Outline<T> outline() {
            return OutlineImpl.this;
        }

        @Override
        public Bean<T> set(Consumer<T> propertyInvoker, Value value) {
            Property descriptor = OutlineImpl.this.property(propertyInvoker);
            Class<?> type = descriptor.type();
            OutlineImpl.this.propertySetterSwitch.doSwitch(type, descriptor, this.instance, value);
            return this;
        }

        @Override
        public <P> Bean<T> set(Consumer<T> propertyInvoker, P value) {
            OutlineImpl.this.property(propertyInvoker).set(this.instance, value);
            return this;
        }

        @Override
        public T unwrap() {
            return this.instance;
        }
    }
}

