/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.json;

import foundation.stack.datamill.json.Json;
import foundation.stack.datamill.json.JsonArray;
import foundation.stack.datamill.json.JsonException;
import foundation.stack.datamill.reflection.Member;
import foundation.stack.datamill.reflection.impl.TripleArgumentTypeSwitch;
import foundation.stack.datamill.values.ReflectableValue;
import foundation.stack.datamill.values.Value;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonObject
implements Json,
ReflectableValue {
    private static final TripleArgumentTypeSwitch<JSONObject, String, JsonProperty, Object> propertyAsObjectSwitch = new TripleArgumentTypeSwitch<JSONObject, String, JsonProperty, Object>(){

        @Override
        protected Object caseBoolean(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? Boolean.valueOf(value3.asBoolean()) : null;
        }

        @Override
        protected Object caseByte(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? Byte.valueOf(value3.asByte()) : null;
        }

        @Override
        protected Object caseCharacter(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? Character.valueOf(value3.asCharacter()) : null;
        }

        @Override
        protected Object caseShort(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? Short.valueOf(value3.asShort()) : null;
        }

        @Override
        protected Object caseInteger(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? Integer.valueOf(value3.asInteger()) : null;
        }

        @Override
        protected Object caseLong(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? Long.valueOf(value3.asLong()) : null;
        }

        @Override
        protected Object caseFloat(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? Float.valueOf(value3.asFloat()) : null;
        }

        @Override
        protected Object caseDouble(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? Double.valueOf(value3.asDouble()) : null;
        }

        @Override
        protected Object caseLocalDateTime(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? value3.asLocalDateTime() : null;
        }

        @Override
        protected Object caseByteArray(JSONObject value1, String value2, JsonProperty value3) {
            return value1.has(value2) ? value3.asByteArray() : null;
        }

        @Override
        protected Object defaultCase(JSONObject value1, String value2, JsonProperty value3) {
            return value3.asJson();
        }
    };
    final JSONObject object;

    private JsonObject(JSONObject object) {
        this.object = object;
    }

    public JsonObject() {
        this.object = new JSONObject();
    }

    public JsonObject(String json) {
        this.object = new JSONObject(json);
    }

    public JsonObject(Map<String, Object> values) {
        this.object = new JSONObject(values);
    }

    @Override
    public boolean asBoolean() {
        throw new JsonException("A JSON object cannot be converted to a boolean!");
    }

    @Override
    public byte asByte() {
        throw new JsonException("A JSON object cannot be converted to a byte!");
    }

    @Override
    public byte[] asByteArray() {
        return this.asString().getBytes();
    }

    @Override
    public char asCharacter() {
        throw new JsonException("A JSON object cannot be converted to a character!");
    }

    @Override
    public float asFloat() {
        throw new JsonException("A JSON object cannot be converted to a float!");
    }

    @Override
    public int asInteger() {
        throw new JsonException("A JSON object cannot be converted to an integer!");
    }

    @Override
    public double asDouble() {
        throw new JsonException("A JSON object cannot be converted to a double!");
    }

    @Override
    public LocalDateTime asLocalDateTime() {
        throw new JsonException("A JSON object cannot be converted to a LocalDateTime!");
    }

    @Override
    public long asLong() {
        throw new JsonException("A JSON object cannot be converted to a long!");
    }

    @Override
    public Object asObject(Class<?> type) {
        if (type == String.class) {
            return this.asString();
        }
        return this;
    }

    @Override
    public short asShort() {
        throw new JsonException("A JSON object cannot be converted to a short!");
    }

    @Override
    public String asString() {
        return this.object.toString();
    }

    public JsonProperty get(String property) {
        return new JsonProperty(property);
    }

    public JsonProperty get(Member member) {
        return this.get(member.name());
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isCharacter() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public <T> T map(Function<Value, T> mapper) {
        return mapper.apply(this);
    }

    public <T> JsonObject put(String key, T value) {
        this.object.put(key, value);
        return this;
    }

    public JsonObject put(String key, JsonObject object) {
        this.object.put(key, (Object)object.object);
        return this;
    }

    public JsonObject put(String key, JsonArray array) {
        this.object.put(key, (Object)array.array);
        return this;
    }

    public <T> JsonObject put(Member member, T value) {
        return this.put(member.name(), value);
    }

    public Set<String> propertyNames() {
        return this.object.keySet();
    }

    public String toString() {
        return this.asString();
    }

    public class JsonProperty
    implements Value {
        private String name;

        private JsonProperty(String name) {
            this.name = name;
        }

        @Override
        public boolean asBoolean() {
            return JsonObject.this.object.getBoolean(this.name);
        }

        @Override
        public byte asByte() {
            return (byte)JsonObject.this.object.getInt(this.name);
        }

        @Override
        public byte[] asByteArray() {
            block4: {
                try {
                    JSONArray array = JsonObject.this.object.getJSONArray(this.name);
                    if (array != null) {
                        byte[] bytes = new byte[array.length()];
                        for (int i = 0; i < bytes.length; ++i) {
                            bytes[i] = (byte)array.getInt(i);
                        }
                        return bytes;
                    }
                }
                catch (JSONException e) {
                    String value = this.asString();
                    if (value == null) break block4;
                    return value.getBytes();
                }
            }
            return null;
        }

        @Override
        public char asCharacter() {
            try {
                return (char)JsonObject.this.object.getInt(this.name);
            }
            catch (JSONException e) {
                String value = JsonObject.this.object.getString(this.name);
                if (value.length() == 1) {
                    return value.charAt(0);
                }
                throw new JsonException("Property cannot be converted to a character!");
            }
        }

        @Override
        public double asDouble() {
            return JsonObject.this.object.getDouble(this.name);
        }

        @Override
        public float asFloat() {
            return JsonObject.this.object.getBigDecimal(this.name).floatValue();
        }

        @Override
        public int asInteger() {
            return JsonObject.this.object.getInt(this.name);
        }

        public JsonArray asJsonArray() {
            JSONArray array = JsonObject.this.object.optJSONArray(this.name);
            if (array != null) {
                return new JsonArray(array);
            }
            return null;
        }

        public JsonObject asJson() {
            JSONObject json = JsonObject.this.object.optJSONObject(this.name);
            if (json != null) {
                return new JsonObject(json);
            }
            return null;
        }

        @Override
        public LocalDateTime asLocalDateTime() {
            String value = JsonObject.this.object.optString(this.name);
            if (value != null) {
                return LocalDateTime.parse(value);
            }
            return null;
        }

        @Override
        public long asLong() {
            return JsonObject.this.object.getLong(this.name);
        }

        @Override
        public Object asObject(Class<?> type) {
            return propertyAsObjectSwitch.doSwitch(type, JsonObject.this.object, this.name, this);
        }

        @Override
        public short asShort() {
            return (short)JsonObject.this.object.getInt(this.name);
        }

        @Override
        public String asString() {
            return JsonObject.this.object.optString(this.name);
        }

        @Override
        public <T> T map(Function<Value, T> mapper) {
            return null;
        }
    }
}

