/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import foundation.stack.datamill.http.Entity;
import foundation.stack.datamill.http.HttpException;
import foundation.stack.datamill.json.JsonObject;
import foundation.stack.datamill.values.Value;
import rx.Observable;

public class ValueEntity
implements Entity {
    private Value value;

    public ValueEntity(Value value) {
        this.value = value;
    }

    @Override
    public Observable<byte[]> asBytes() {
        return this.asString().map(s -> s.getBytes());
    }

    @Override
    public Observable<byte[]> asChunks() {
        return this.asBytes();
    }

    @Override
    public Observable<JsonObject> asJson() {
        if (this.value instanceof JsonObject) {
            return Observable.just((Object)((JsonObject)this.value));
        }
        return Observable.error((Throwable)new HttpException("Value is not JSON!"));
    }

    @Override
    public Observable<String> asString() {
        if (this.value == null) {
            return Observable.empty();
        }
        return Observable.just((Object)this.value.asString());
    }
}

