/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriTemplateRegion {
    private final String variable;
    private final String content;
    private final Pattern pattern;

    public UriTemplateRegion(String content) {
        this.variable = null;
        this.content = content;
        this.pattern = null;
    }

    public UriTemplateRegion(String variable, String content) {
        this.variable = variable;
        this.content = content;
        this.pattern = content != null ? Pattern.compile(content) : null;
    }

    public String getVariable() {
        return this.variable;
    }

    public boolean isDefaultPattern() {
        return this.content == null;
    }

    public boolean isFixedContent() {
        return this.variable == null;
    }

    public int match(String uri, int start) {
        if (this.isFixedContent()) {
            return this.matchFixedContent(uri, start);
        }
        if (this.isDefaultPattern()) {
            return this.matchDefaultPatternContent(uri, start);
        }
        return this.matchCustomPatternContent(uri, start);
    }

    private int matchCustomPatternContent(String uri, int start) {
        Matcher matcher = this.pattern.matcher(uri);
        if (matcher.find(start) && matcher.start() == start) {
            return matcher.end();
        }
        return -1;
    }

    private int matchDefaultPatternContent(String uri, int start) {
        int position;
        int uriLength = uri.length();
        for (position = start; position < uriLength && uri.charAt(position) != '/'; ++position) {
        }
        return position;
    }

    private int matchFixedContent(String uri, int start) {
        if (start + this.content.length() > uri.length()) {
            return -1;
        }
        if (uri.substring(start, start + this.content.length()).equals(this.content)) {
            return start + this.content.length();
        }
        return -1;
    }

    public String toString() {
        if (this.isFixedContent()) {
            return this.content;
        }
        if (this.isDefaultPattern()) {
            return "{" + this.variable + '}';
        }
        return "{" + this.variable + ':' + this.pattern + '}';
    }
}

