/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import foundation.stack.datamill.http.impl.UriTemplateRegion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriTemplate {
    private static final String TEMPLATE_REGEX = "(:\\s*([^\\}]*)\\s*)?";
    private static final String TEMPLATE_VARIABLE = "(\\w[\\w\\.-]*)";
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^\\}]*)\\s*)?\\}");
    private final List<UriTemplateRegion> regions = new ArrayList<UriTemplateRegion>();

    private static String stripSlashes(String uri) {
        int end;
        int start = 0;
        if (uri.charAt(0) == '/') {
            start = 1;
        }
        if (uri.charAt(end = uri.length() - 1) == '/') {
            --end;
        }
        if (end > start) {
            return uri.substring(start, end + 1);
        }
        return "";
    }

    public UriTemplate(String template) {
        this.computeTemplateRegions(template);
    }

    private void computeTemplateRegions(String template) {
        template = UriTemplate.stripSlashes(template);
        int previousRegion = 0;
        Matcher matcher = TEMPLATE_PATTERN.matcher(template);
        while (matcher.find()) {
            int regionStart = matcher.start();
            int regionEnd = matcher.end();
            if (previousRegion < regionStart) {
                this.regions.add(new UriTemplateRegion(template.substring(previousRegion, regionStart)));
            }
            this.addMatchedVariableRegion(matcher);
            previousRegion = regionEnd;
        }
        if (previousRegion < template.length()) {
            this.regions.add(new UriTemplateRegion(template.substring(previousRegion)));
        }
    }

    private void addMatchedVariableRegion(Matcher matcher) {
        String variableName = matcher.group(1);
        String regex = matcher.group(3);
        if (regex == null) {
            this.regions.add(new UriTemplateRegion(variableName, null));
        } else {
            this.regions.add(new UriTemplateRegion(variableName, regex));
        }
    }

    public Map<String, String> match(String uri) {
        uri = UriTemplate.stripSlashes(uri);
        HashMap<String, String> matches = null;
        int uriLength = uri.length();
        int position = 0;
        for (UriTemplateRegion region : this.regions) {
            if (position > uriLength) {
                return null;
            }
            int regionEnd = region.match(uri, position);
            if (regionEnd < 0) {
                return null;
            }
            if (!region.isFixedContent()) {
                if (matches == null) {
                    matches = new HashMap<String, String>();
                }
                matches.put(region.getVariable(), uri.substring(position, regionEnd));
            }
            position = regionEnd;
        }
        if (position != uri.length()) {
            return null;
        }
        if (matches == null) {
            return Collections.emptyMap();
        }
        return matches;
    }

    public String toString() {
        StringBuilder template = new StringBuilder();
        for (UriTemplateRegion region : this.regions) {
            template.append(region.toString());
        }
        return template.toString();
    }
}

