/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import foundation.stack.datamill.http.Entity;
import foundation.stack.datamill.http.HttpException;
import foundation.stack.datamill.json.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import rx.Observable;

public class StreamedChunksEntity
implements Entity {
    private final Observable<byte[]> chunks;
    private final Charset charset;

    public StreamedChunksEntity(Observable<byte[]> chunks, Charset charset) {
        this.chunks = chunks;
        this.charset = charset;
    }

    @Override
    public Observable<byte[]> asBytes() {
        return this.asChunks().collect(() -> new ByteArrayOutputStream(), (stream, chunk) -> {
            try {
                stream.write((byte[])chunk);
            }
            catch (IOException e) {
                throw new HttpException(e);
            }
        }).map(os -> os.toByteArray());
    }

    @Override
    public Observable<byte[]> asChunks() {
        return this.chunks;
    }

    @Override
    public Observable<JsonObject> asJson() {
        return this.asString().map(string -> new JsonObject((String)string));
    }

    @Override
    public Observable<String> asString() {
        return this.asBytes().map(bytes -> new String((byte[])bytes, this.charset));
    }
}

