/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import foundation.stack.datamill.http.Entity;
import foundation.stack.datamill.http.RequestHeader;
import foundation.stack.datamill.http.Response;
import foundation.stack.datamill.http.ResponseBuilder;
import foundation.stack.datamill.http.ServerRequest;
import foundation.stack.datamill.http.impl.AbstractRequestImpl;
import foundation.stack.datamill.http.impl.ResponseBuilderImpl;
import foundation.stack.datamill.values.Value;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import rx.Observable;

public class ServerRequestImpl
extends AbstractRequestImpl
implements ServerRequest {
    private final ExecutorService entityStreamingThreadPool;
    private Multimap<String, String> queryParameters;
    private QueryStringDecoder queryStringDecoder;
    private Multimap<String, String> trailingHeaders;

    public ServerRequestImpl(String method, Multimap<String, String> headers, String uri, Charset charset, Entity entity, ExecutorService threadPool) {
        super(method, headers, uri, entity);
        this.queryStringDecoder = new QueryStringDecoder(uri, charset);
        this.entityStreamingThreadPool = threadPool;
    }

    private Multimap<String, String> extractQueryParameters() {
        ImmutableMultimap queryParameters;
        Map params = this.queryStringDecoder.parameters();
        if (!params.isEmpty()) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Map.Entry p : params.entrySet()) {
                String key = (String)p.getKey();
                List values = (List)p.getValue();
                for (String value : values) {
                    builder.put((Object)key, (Object)value);
                }
            }
            queryParameters = builder.build();
        } else {
            queryParameters = null;
            this.queryStringDecoder = null;
        }
        return queryParameters;
    }

    @Override
    public Value firstTrailingHeader(String header) {
        return ServerRequestImpl.firstValue(this.trailingHeaders, header);
    }

    @Override
    public Value firstTrailingHeader(RequestHeader header) {
        return this.firstTrailingHeader(header.getName());
    }

    @Override
    public Multimap<String, String> queryParameters() {
        if (this.queryParameters == null && this.queryStringDecoder != null) {
            this.queryParameters = this.extractQueryParameters();
        }
        return this.queryParameters;
    }

    @Override
    public Map<String, Object> options() {
        return Collections.emptyMap();
    }

    @Override
    public Observable<Response> respond(Function<ResponseBuilder, Response> responseBuilder) {
        return Observable.just((Object)responseBuilder.apply(new ResponseBuilderImpl(this.entityStreamingThreadPool)));
    }

    public void setTrailingHeaders(Multimap<String, String> trailingHeaders) {
        this.trailingHeaders = trailingHeaders;
    }

    @Override
    public Multimap<String, String> trailingHeaders() {
        return this.trailingHeaders;
    }
}

