/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import foundation.stack.datamill.http.impl.ServerRequestImpl;
import foundation.stack.datamill.http.impl.StreamedChunksEntity;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import rx.Observable;

public class ServerRequestBuilder {
    public static ServerRequestImpl buildServerRequest(HttpRequest request, Observable<byte[]> entityStream, ExecutorService threadPool) {
        Charset messageCharset = HttpUtil.getCharset((HttpMessage)request);
        return new ServerRequestImpl(request.method().name(), ServerRequestBuilder.buildHeadersMap(request.headers()), request.uri(), messageCharset, new StreamedChunksEntity(entityStream, messageCharset), threadPool);
    }

    public static Multimap<String, String> buildHeadersMap(HttpHeaders headers) {
        ImmutableMultimap headersMap;
        HttpHeaders requestHeaders = headers;
        if (!requestHeaders.isEmpty()) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Map.Entry header : requestHeaders) {
                String key = (String)header.getKey();
                String value = (String)header.getValue();
                if (key == null || value == null) continue;
                builder.put((Object)key, (Object)value);
            }
            headersMap = builder.build();
        } else {
            headersMap = null;
        }
        return headersMap;
    }
}

