/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import foundation.stack.datamill.http.Entity;
import foundation.stack.datamill.http.Method;
import foundation.stack.datamill.http.Request;
import foundation.stack.datamill.http.RequestBuilder;
import foundation.stack.datamill.http.RequestHeader;
import foundation.stack.datamill.http.impl.RequestImpl;
import foundation.stack.datamill.http.impl.ValueEntity;
import foundation.stack.datamill.values.Value;
import java.util.HashMap;
import java.util.Map;

public class RequestBuilderImpl
implements RequestBuilder {
    private Entity entity;
    private final Multimap<String, String> headers = LinkedListMultimap.create();
    private String method;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final Multimap<String, String> queryParameters = LinkedListMultimap.create();
    private String uri;
    private final Map<String, String> uriParameters = new HashMap<String, String>();

    @Override
    public Request build() {
        return new RequestImpl(this.method, this.headers, this.uri, this.queryParameters, this.uriParameters, this.options, this.entity);
    }

    @Override
    public RequestBuilder connectTimeout(int milliseconds) {
        this.options.put("connectTimeout", milliseconds);
        return this;
    }

    @Override
    public RequestBuilder entity(Entity entity) {
        this.entity = entity;
        return this;
    }

    @Override
    public RequestBuilder entity(Value entity) {
        this.entity = new ValueEntity(entity);
        return this;
    }

    @Override
    public RequestBuilder header(RequestHeader header, String value) {
        return this.header(header.getName(), value);
    }

    @Override
    public RequestBuilder header(String name, String value) {
        this.headers.put((Object)name, (Object)value);
        return this;
    }

    @Override
    public RequestBuilder method(Method method) {
        this.method = method.name();
        return this;
    }

    @Override
    public RequestBuilder method(String method) {
        this.method = method;
        return this;
    }

    @Override
    public RequestBuilder queryParameter(String name, String value) {
        this.queryParameters.put((Object)name, (Object)value);
        return this;
    }

    @Override
    public RequestBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public <T> RequestBuilder uriParameter(String name, T value) {
        this.uriParameters.put(name, value.toString());
        return this;
    }
}

