/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import foundation.stack.datamill.http.Method;
import foundation.stack.datamill.http.Route;
import foundation.stack.datamill.http.ServerRequest;
import foundation.stack.datamill.http.impl.RouteMatcher;
import foundation.stack.datamill.http.impl.ServerRequestImpl;
import foundation.stack.datamill.http.impl.UriTemplate;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodAndUriMatcher
extends RouteMatcher {
    private static final Logger logger = LoggerFactory.getLogger(MethodAndUriMatcher.class);
    private final Method method;
    private final UriTemplate uriTemplate;

    public MethodAndUriMatcher(Method method, String pattern, Route route) {
        super(route);
        this.method = method;
        this.uriTemplate = pattern != null ? new UriTemplate(pattern) : null;
    }

    @Override
    public boolean matches(ServerRequest request) {
        boolean matches;
        boolean bl = matches = this.matchesMethod(request) && this.matchesUri(request);
        if (matches) {
            logger.debug("Request matched {} {}", (Object)this.method, this.uriTemplate == null ? "*" : this.uriTemplate);
        }
        return matches;
    }

    private boolean matchesUri(ServerRequest request) {
        if (this.uriTemplate != null) {
            Map<String, String> uriParameters = this.uriTemplate.match(request.uri());
            if (uriParameters != null) {
                if (!uriParameters.isEmpty()) {
                    ((ServerRequestImpl)request).setUriParameters(uriParameters);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesMethod(ServerRequest request) {
        return this.method != null ? request.method() == this.method : true;
    }

    @Override
    public Set<Method> queryOptions(ServerRequest request) {
        if (this.matchesUri(request) && request.method() == Method.OPTIONS) {
            return this.method == null ? Method.allMethods() : EnumSet.of(this.method);
        }
        return null;
    }
}

