/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import com.google.common.base.Joiner;
import foundation.stack.datamill.http.Method;
import foundation.stack.datamill.http.PostProcessedRoute;
import foundation.stack.datamill.http.Response;
import foundation.stack.datamill.http.Route;
import foundation.stack.datamill.http.ServerRequest;
import foundation.stack.datamill.http.impl.Matcher;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;

public class MatcherBasedRoute
implements PostProcessedRoute {
    private final List<Matcher> matchers;
    private final List<Func1<Response, Response>> postProcessors = new ArrayList<Func1<Response, Response>>();

    public MatcherBasedRoute(List<Matcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public Route andFinally(Func1<Response, Response> postProcessor) {
        this.postProcessors.add(postProcessor);
        return this;
    }

    private Response postProcess(Response response) {
        for (Func1<Response, Response> postProcessor : this.postProcessors) {
            response = (Response)postProcessor.call((Object)response);
        }
        return response;
    }

    @Override
    public Observable<Response> apply(ServerRequest request) {
        if (request.method() == Method.OPTIONS) {
            EnumSet<Method> availableMethods = EnumSet.noneOf(Method.class);
            for (Matcher matcher : this.matchers) {
                Set<Method> matcherMethods = matcher.queryOptions(request);
                if (matcherMethods == null) continue;
                availableMethods.addAll(matcherMethods);
            }
            if (availableMethods.size() > 0) {
                return request.respond(b -> b.header("Access-Control-Allow-Methods", Joiner.on((char)',').join((Iterable)availableMethods)).ok()).map(this::postProcess);
            }
        }
        for (Matcher matcher : this.matchers) {
            Observable<Response> responseObservable = matcher.applyIfMatches(request);
            if (responseObservable == null) continue;
            return responseObservable.map(this::postProcess);
        }
        return Observable.empty();
    }
}

