/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import foundation.stack.datamill.http.Entity;
import foundation.stack.datamill.http.HttpException;
import foundation.stack.datamill.json.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import rx.Observable;
import rx.functions.Action0;
import rx.observables.StringObservable;

public class InputStreamEntity
implements Entity {
    private final InputStream inputStream;
    private final Action0 completionHandler;

    public InputStreamEntity(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputStreamEntity(InputStream inputStream, Action0 completionHandler) {
        this.inputStream = inputStream;
        this.completionHandler = completionHandler;
    }

    @Override
    public Observable<byte[]> asBytes() {
        return this.asChunks().collect(() -> new ByteArrayOutputStream(), (stream, chunk) -> {
            try {
                stream.write((byte[])chunk);
            }
            catch (IOException e) {
                throw new HttpException(e);
            }
        }).map(os -> os.toByteArray());
    }

    @Override
    public Observable<JsonObject> asJson() {
        return this.asString().map(string -> new JsonObject((String)string));
    }

    @Override
    public Observable<byte[]> asChunks() {
        return StringObservable.from((InputStream)this.inputStream).doAfterTerminate(this.completionHandler != null ? this.completionHandler : () -> {});
    }

    @Override
    public Observable<String> asString() {
        return this.asBytes().map(bytes -> new String((byte[])bytes));
    }
}

