/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import foundation.stack.datamill.http.Response;
import foundation.stack.datamill.http.Route;
import foundation.stack.datamill.http.ServerRequest;
import foundation.stack.datamill.http.impl.ClientToServerChannelHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ClientToServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger logger = LoggerFactory.getLogger(ClientToServerChannelInitializer.class);
    private final BiFunction<ServerRequest, Throwable, Observable<Response>> errorResponseConstructor;
    private final Route route;
    private final SslContext sslContext;
    private final ExecutorService threadPool;

    public ClientToServerChannelInitializer(SslContext sslContext, ExecutorService threadPool, Route route, BiFunction<ServerRequest, Throwable, Observable<Response>> errorResponseConstructor) {
        this.sslContext = sslContext;
        this.threadPool = threadPool;
        this.route = route;
        this.errorResponseConstructor = errorResponseConstructor;
    }

    protected void initChannel(SocketChannel channel) throws Exception {
        logger.debug("Initializing channel from client {} to the server", (Object)channel.remoteAddress());
        ChannelPipeline pipeline = channel.pipeline();
        if (this.sslContext != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslContext.newHandler(channel.alloc())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec(4096, 8192, 65536)});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
        pipeline.addLast(new ChannelHandler[]{new ClientToServerChannelHandler(this.threadPool, this.route, this.errorResponseConstructor)});
    }
}

