/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import foundation.stack.datamill.http.Method;
import foundation.stack.datamill.http.Response;
import foundation.stack.datamill.http.Route;
import foundation.stack.datamill.http.ServerRequest;
import foundation.stack.datamill.http.annotations.DELETE;
import foundation.stack.datamill.http.annotations.GET;
import foundation.stack.datamill.http.annotations.HEAD;
import foundation.stack.datamill.http.annotations.OPTIONS;
import foundation.stack.datamill.http.annotations.PATCH;
import foundation.stack.datamill.http.annotations.POST;
import foundation.stack.datamill.http.annotations.PUT;
import foundation.stack.datamill.http.annotations.Path;
import foundation.stack.datamill.http.impl.Matcher;
import foundation.stack.datamill.http.impl.MethodAndUriMatcher;
import foundation.stack.datamill.http.impl.RouteMatcher;
import foundation.stack.datamill.reflection.Bean;
import foundation.stack.datamill.reflection.Outline;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import rx.Observable;

public class BeanMethodMatcher
implements Matcher {
    private final Outline<?> beanOutline;
    private final List<RouteMatcher> matchers = new ArrayList<RouteMatcher>();
    private final BiFunction<ServerRequest, foundation.stack.datamill.reflection.Method, Observable<Response>> route;

    private static String combinePaths(String path1, String path2) {
        if (path2 == null) {
            path2 = "";
        }
        String combined = path1.endsWith("/") ? (path2.startsWith("/") ? path1 + path2.substring(1) : path1 + path2) : (path2.startsWith("/") ? path1 + path2 : path1 + "/" + path2);
        return combined;
    }

    public BeanMethodMatcher(Bean<?> bean, BiFunction<ServerRequest, foundation.stack.datamill.reflection.Method, Observable<Response>> route) {
        this.beanOutline = bean.outline();
        this.route = route;
        this.createBeanMethodMatchers();
    }

    private void createBeanMethodMatchers() {
        String path = null;
        Path pathAnnotation = this.beanOutline.getAnnotation(Path.class);
        if (pathAnnotation != null) {
            path = pathAnnotation.value();
        }
        String beanPath = path;
        this.beanOutline.methods().stream().forEach(method -> {
            String methodPath = beanPath;
            Path methodPathAnnotation = method.getAnnotation(Path.class);
            if (methodPathAnnotation != null) {
                methodPath = BeanMethodMatcher.combinePaths(beanPath == null ? "" : beanPath, methodPathAnnotation.value());
            }
            Route handler = request -> this.route.apply((ServerRequest)request, (foundation.stack.datamill.reflection.Method)method);
            if (method.hasAnnotation(DELETE.class)) {
                this.matchers.add(new MethodAndUriMatcher(Method.DELETE, methodPath, handler));
            }
            if (method.hasAnnotation(GET.class)) {
                this.matchers.add(new MethodAndUriMatcher(Method.GET, methodPath, handler));
            }
            if (method.hasAnnotation(HEAD.class)) {
                this.matchers.add(new MethodAndUriMatcher(Method.HEAD, methodPath, handler));
            }
            if (method.hasAnnotation(OPTIONS.class)) {
                this.matchers.add(new MethodAndUriMatcher(Method.OPTIONS, methodPath, handler));
            }
            if (method.hasAnnotation(PATCH.class)) {
                this.matchers.add(new MethodAndUriMatcher(Method.PATCH, methodPath, handler));
            }
            if (method.hasAnnotation(POST.class)) {
                this.matchers.add(new MethodAndUriMatcher(Method.POST, methodPath, handler));
            }
            if (method.hasAnnotation(PUT.class)) {
                this.matchers.add(new MethodAndUriMatcher(Method.PUT, methodPath, handler));
            }
        });
    }

    @Override
    public Observable<Response> applyIfMatches(ServerRequest request) {
        for (Matcher matcher : this.matchers) {
            Observable<Response> responseObservable = matcher.applyIfMatches(request);
            if (responseObservable == null) continue;
            return responseObservable;
        }
        return null;
    }

    @Override
    public Set<Method> queryOptions(ServerRequest request) {
        EnumSet<Method> methods = EnumSet.noneOf(Method.class);
        for (Matcher matcher : this.matchers) {
            Set<Method> matchedMethods = matcher.queryOptions(request);
            if (matchedMethods == null) continue;
            methods.addAll(matchedMethods);
        }
        if (methods.size() > 0) {
            return methods;
        }
        return null;
    }
}

