/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http.impl;

import com.google.common.collect.Multimap;
import foundation.stack.datamill.http.Entity;
import foundation.stack.datamill.http.Method;
import foundation.stack.datamill.http.Request;
import foundation.stack.datamill.http.RequestHeader;
import foundation.stack.datamill.values.StringValue;
import foundation.stack.datamill.values.Value;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractRequestImpl
implements Request {
    private final Multimap<String, String> headers;
    private final String method;
    private final String uri;
    private Map<String, String> uriParameters;
    private final Entity entity;

    protected static Value firstValue(Multimap<String, String> entries, String name) {
        Collection values;
        if (entries != null && (values = entries.get((Object)name)).size() > 0) {
            return new StringValue((String)values.iterator().next());
        }
        return null;
    }

    protected AbstractRequestImpl(String method, Multimap<String, String> headers, String uri, Entity entity) {
        this.method = method;
        this.headers = headers;
        this.uri = uri;
        this.entity = entity;
    }

    @Override
    public Entity entity() {
        return this.entity;
    }

    @Override
    public Value firstHeader(String header) {
        return AbstractRequestImpl.firstValue(this.headers, header);
    }

    @Override
    public Value firstHeader(RequestHeader header) {
        return this.firstHeader(header.getName());
    }

    @Override
    public Value firstQueryParameter(String name) {
        return AbstractRequestImpl.firstValue(this.queryParameters(), name);
    }

    @Override
    public Multimap<String, String> headers() {
        return this.headers;
    }

    @Override
    public Method method() {
        try {
            return Method.valueOf(this.method);
        }
        catch (IllegalArgumentException e) {
            return Method.UNKNOWN;
        }
    }

    @Override
    public String rawMethod() {
        return this.method;
    }

    protected void setUriParameters(Map<String, String> uriParameters) {
        this.uriParameters = uriParameters;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public Value uriParameter(String parameter) {
        String value;
        if (this.uriParameters != null && (value = this.uriParameters.get(parameter)) != null) {
            return new StringValue(value);
        }
        return null;
    }

    @Override
    public Map<String, String> uriParameters() {
        return this.uriParameters;
    }
}

