/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.http;

import foundation.stack.datamill.http.Response;
import foundation.stack.datamill.http.Route;
import foundation.stack.datamill.http.ServerRequest;
import foundation.stack.datamill.http.builder.RouteBuilder;
import foundation.stack.datamill.http.impl.ClientToServerChannelInitializer;
import foundation.stack.datamill.http.impl.RouteBuilderImpl;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private final BiFunction<ServerRequest, Throwable, Observable<Response>> errorResponseConstructor;
    private EventLoopGroup eventLoopGroup;
    private final Function<RouteBuilder, Route> routeConstructor;
    private Channel serverChannel;
    private final ExecutorService threadPool = Executors.newCachedThreadPool();

    public Server(Function<RouteBuilder, Route> routeConstructor) {
        this(routeConstructor, null);
    }

    public Server(Function<RouteBuilder, Route> routeConstructor, BiFunction<ServerRequest, Throwable, Observable<Response>> errorResponseConstructor) {
        this.routeConstructor = routeConstructor;
        this.errorResponseConstructor = errorResponseConstructor;
    }

    public Server listen(String host, int port, boolean secure) {
        SslContext sslContext = null;
        try {
            if (secure) {
                SelfSignedCertificate certificate = new SelfSignedCertificate();
                sslContext = SslContextBuilder.forServer((File)certificate.certificate(), (File)certificate.privateKey()).build();
            }
        }
        catch (CertificateException | SSLException certificate) {
            // empty catch block
        }
        Route route = this.routeConstructor.apply(new RouteBuilderImpl());
        this.eventLoopGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)8)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)15000)).handler((ChannelHandler)new LoggingHandler())).childHandler((ChannelHandler)new ClientToServerChannelInitializer(null, this.threadPool, route, this.errorResponseConstructor)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        try {
            logger.debug("Starting HTTP server on {}:{}", (Object)host, (Object)port);
            this.serverChannel = bootstrap.bind(host, port).sync().channel();
            logger.debug("HTTP server listening on port {}:{}", (Object)host, (Object)port);
        }
        catch (InterruptedException e) {
            logger.debug("Error occurred while HTTP server was listening on {}:{}", new Object[]{host, port, e});
            this.stop();
        }
        return this;
    }

    public Server listen(String host, int port) {
        return this.listen(host, port, false);
    }

    public Server listen(int port) {
        return this.listen("localhost", port);
    }

    public Server listen(int port, boolean secure) {
        return this.listen("localhost", port, secure);
    }

    public void stop() {
        try {
            logger.debug("Shutting down HTTP server");
            this.serverChannel.close().sync();
        }
        catch (InterruptedException e) {
            logger.debug("Error occurred during HTTP server shut down", (Throwable)e);
        }
        finally {
            this.eventLoopGroup.shutdownGracefully();
            logger.debug("HTTP server was shut down");
        }
    }
}

