/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.db.impl;

import foundation.stack.datamill.db.DatabaseException;
import foundation.stack.datamill.db.Row;
import foundation.stack.datamill.reflection.Member;
import foundation.stack.datamill.values.Value;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.function.Function;

public class RowImpl
implements Row {
    private final ResultSet resultSet;

    public RowImpl(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public Value column(int index) {
        return new IndexedColumnValue(index);
    }

    @Override
    public Value column(String name) {
        return new LabeledColumnValue(name);
    }

    @Override
    public Value column(String table, String name) {
        return new LabeledColumnValue(table + "." + name);
    }

    @Override
    public Value column(Member member) {
        return this.column(member.outline().pluralName(), member.name());
    }

    @Override
    public int size() {
        try {
            return this.resultSet.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private class LabeledColumnValue
    extends KeyedColumnValue<String> {
        public LabeledColumnValue(String label) {
            super(label);
        }

        @Override
        public byte asByte() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getByte((String)this.key));
        }

        @Override
        public byte[] asByteArray() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getBytes((String)this.key));
        }

        @Override
        public char asCharacter() {
            return this.safeRetrieve(k -> Character.valueOf((char)RowImpl.this.resultSet.getInt((String)this.key))).charValue();
        }

        @Override
        public double asDouble() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getDouble((String)this.key));
        }

        @Override
        public LocalDateTime asLocalDateTime() {
            return this.safeRetrieve(k -> {
                Timestamp timestap = RowImpl.this.resultSet.getTimestamp((String)this.key);
                if (timestap != null) {
                    return timestap.toLocalDateTime();
                }
                return null;
            });
        }

        @Override
        public long asLong() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getLong((String)this.key));
        }

        @Override
        public int asInteger() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getInt((String)this.key));
        }

        @Override
        public float asFloat() {
            return this.safeRetrieve(k -> Float.valueOf(RowImpl.this.resultSet.getFloat((String)this.key))).floatValue();
        }

        @Override
        public boolean asBoolean() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getBoolean((String)this.key));
        }

        @Override
        public Object asObject(Class<?> type) {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getObject((String)this.key));
        }

        @Override
        public short asShort() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getShort((String)this.key));
        }

        @Override
        public String asString() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getString((String)this.key));
        }
    }

    private class IndexedColumnValue
    extends KeyedColumnValue<Integer> {
        public IndexedColumnValue(int index) {
            super(index);
        }

        @Override
        public byte asByte() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getByte((Integer)this.key));
        }

        @Override
        public byte[] asByteArray() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getBytes((Integer)this.key));
        }

        @Override
        public char asCharacter() {
            return this.safeRetrieve(k -> Character.valueOf((char)RowImpl.this.resultSet.getInt((Integer)this.key))).charValue();
        }

        @Override
        public double asDouble() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getDouble((Integer)this.key));
        }

        @Override
        public LocalDateTime asLocalDateTime() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getTimestamp((Integer)this.key).toLocalDateTime());
        }

        @Override
        public long asLong() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getLong((Integer)this.key));
        }

        @Override
        public int asInteger() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getInt((Integer)this.key));
        }

        @Override
        public float asFloat() {
            return this.safeRetrieve(k -> Float.valueOf(RowImpl.this.resultSet.getFloat((Integer)this.key))).floatValue();
        }

        @Override
        public boolean asBoolean() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getBoolean((Integer)this.key));
        }

        @Override
        public Object asObject(Class<?> type) {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getObject((Integer)this.key));
        }

        @Override
        public short asShort() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getShort((Integer)this.key));
        }

        @Override
        public String asString() {
            return this.safeRetrieve(k -> RowImpl.this.resultSet.getString((Integer)this.key));
        }
    }

    private abstract class KeyedColumnValue<K>
    implements Value {
        protected final K key;

        public KeyedColumnValue(K key) {
            this.key = key;
        }

        protected <T> T safeRetrieve(ResultSetValueRetriever<K, T> retriever) {
            try {
                return retriever.retrieve(this.key);
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }

        @Override
        public <T> T map(Function<Value, T> mapper) {
            return mapper.apply(this);
        }
    }

    @FunctionalInterface
    private static interface ResultSetValueRetriever<K, R> {
        public R retrieve(K var1) throws SQLException;
    }
}

