/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.db.impl;

import com.google.common.base.Joiner;
import foundation.stack.datamill.db.ConditionBuilder;
import foundation.stack.datamill.db.InsertBuilder;
import foundation.stack.datamill.db.InsertSuffixBuilder;
import foundation.stack.datamill.db.JoinBuilder;
import foundation.stack.datamill.db.QueryBuilder;
import foundation.stack.datamill.db.Row;
import foundation.stack.datamill.db.RowBuilder;
import foundation.stack.datamill.db.SelectBuilder;
import foundation.stack.datamill.db.UpdateBuilder;
import foundation.stack.datamill.db.UpdateQueryExecution;
import foundation.stack.datamill.db.WhereBuilder;
import foundation.stack.datamill.db.impl.RowBuilderImpl;
import foundation.stack.datamill.reflection.Member;
import foundation.stack.datamill.reflection.Outline;
import foundation.stack.datamill.values.Times;
import java.sql.Timestamp;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public abstract class QueryBuilderImpl
implements QueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(QueryBuilderImpl.class);
    private static final InsertSuffixBuilder EMPTY_UPDATE_BUILDER = new EmptyUpdateSuffixBuilder();
    private static final String SQL_ASSIGNMENT = " = ";
    private static final String SQL_DELETE_FROM = "DELETE FROM ";
    private static final String SQL_DELETE = "DELETE ";
    private static final String SQL_EQ = " = ";
    private static final String SQL_FROM = " FROM ";
    private static final String SQL_INSERT_INTO = "INSERT INTO ";
    private static final String SQL_LEFT_JOIN = " LEFT JOIN ";
    private static final String SQL_NULL = "NULL";
    private static final String SQL_ON = " ON ";
    private static final String SQL_ON_DUPLICATE_KEY_UPDATE = " ON DUPLICATE KEY UPDATE ";
    private static final String SQL_PARAMETER_PLACEHOLDER = "?";
    private static final String SQL_SELECT = "SELECT ";
    private static final String SQL_SET = " SET ";
    private static final String SQL_WHERE = " WHERE ";
    private static final String SQL_UPDATE = "UPDATE ";
    private static final String SQL_IS = " IS ";
    private static final String SQL_AND = " AND ";
    private static final String SQL_IN = " IN ";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String COMMA = ",";

    private static void appendUpdateAssignments(StringBuilder query, List<Object> parameters, Map<String, ?> values) {
        ArrayList<String> setters = new ArrayList<String>(values.size());
        for (Map.Entry<String, ?> column : values.entrySet()) {
            StringBuilder setter = new StringBuilder(column.getKey());
            setter.append(" = ");
            Object value = column.getValue();
            if (value == null) {
                setter.append(SQL_NULL);
            } else {
                setter.append(SQL_PARAMETER_PLACEHOLDER);
                parameters.add(value);
            }
            setters.add(setter.toString());
        }
        Joiner.on((String)", ").appendTo(query, setters);
    }

    @Override
    public WhereBuilder<UpdateQueryExecution> deleteFrom(String table) {
        return new UpdateWhereClause(new StringBuilder(SQL_DELETE_FROM).append(table));
    }

    @Override
    public WhereBuilder<UpdateQueryExecution> deleteFrom(Outline<?> outline) {
        return this.deleteFrom(outline.pluralName());
    }

    @Override
    public WhereBuilder<UpdateQueryExecution> deleteFromNamed(String table) {
        return new UpdateWhereClause(new StringBuilder(SQL_DELETE).append(table).append(SQL_FROM).append(table));
    }

    @Override
    public WhereBuilder<UpdateQueryExecution> deleteFromNamed(Outline<?> outline) {
        return this.deleteFromNamed(outline.pluralName());
    }

    @Override
    public InsertBuilder insertInto(String table) {
        return new InsertQuery(table);
    }

    @Override
    public InsertBuilder insertInto(Outline<?> outline) {
        return this.insertInto(outline.pluralName());
    }

    protected abstract Observable<Row> query(String var1);

    protected abstract Observable<Row> query(String var1, Object ... var2);

    protected abstract UpdateQueryExecution update(String var1, Object ... var2);

    @Override
    public SelectBuilder select(String column) {
        return this.select(Arrays.asList(column));
    }

    @Override
    public SelectBuilder select(Member member) {
        return this.selectQualified(member.outline().pluralName(), member.name());
    }

    @Override
    public SelectBuilder select(String ... columns) {
        return this.select(Arrays.asList(columns));
    }

    @Override
    public SelectBuilder select(Member ... members) {
        ArrayList<String> columns = new ArrayList<String>();
        for (Member member : members) {
            columns.add(QueryBuilderImpl.qualifiedName(member.outline().pluralName(), member.name()));
        }
        return this.select(columns);
    }

    @Override
    public SelectBuilder select(Iterable<String> columns) {
        return new SelectQuery(columns);
    }

    private static final String qualifiedName(String table, String column) {
        return table + "." + column;
    }

    @Override
    public SelectBuilder selectQualified(String table, String column) {
        return this.select(QueryBuilderImpl.qualifiedName(table, column));
    }

    @Override
    public SelectBuilder selectQualified(String table, String ... columns) {
        return this.select(Stream.of(columns).map(column -> QueryBuilderImpl.qualifiedName(table, column)).collect(Collectors.toList()));
    }

    @Override
    public SelectBuilder selectQualified(String table, Iterable<String> columns) {
        return this.select(StreamSupport.stream(columns.spliterator(), false).map(column -> QueryBuilderImpl.qualifiedName(table, column)).collect(Collectors.toList()));
    }

    @Override
    public SelectBuilder selectAll() {
        return new SelectQuery();
    }

    @Override
    public SelectBuilder selectAllIn(Outline<?> outline) {
        return this.selectQualified(outline.pluralName(), outline.propertyNames());
    }

    @Override
    public UpdateBuilder update(String table) {
        return new UpdateQuery(table);
    }

    @Override
    public UpdateBuilder update(Outline<?> outline) {
        return this.update(outline.pluralName());
    }

    private static class EmptyUpdateSuffixBuilder
    implements InsertSuffixBuilder {
        private EmptyUpdateSuffixBuilder() {
        }

        @Override
        public Observable<Integer> count() {
            return Observable.just((Object)0);
        }

        @Override
        public Observable<Long> getIds() {
            return Observable.empty();
        }

        @Override
        public UpdateQueryExecution onDuplicateKeyUpdate(Function<RowBuilder, Map<String, ?>> rowConstructor) {
            return this;
        }

        @Override
        public UpdateQueryExecution onDuplicateKeyUpdate(Map<String, ?> values) {
            return this;
        }
    }

    private class SelectQuery
    implements SelectBuilder {
        private final StringBuilder query = new StringBuilder();

        public SelectQuery() {
            this.query.append(QueryBuilderImpl.SQL_SELECT);
            this.query.append('*');
        }

        public SelectQuery(Iterable<String> columns) {
            this.query.append(QueryBuilderImpl.SQL_SELECT);
            this.query.append(Joiner.on((String)", ").join(columns));
        }

        @Override
        public WhereBuilder<Observable<Row>> from(String table) {
            this.query.append(QueryBuilderImpl.SQL_FROM);
            this.query.append(table);
            return new SelectWhereClause(this.query);
        }

        @Override
        public WhereBuilder<Observable<Row>> from(Outline<?> outline) {
            return this.from(outline.pluralName());
        }
    }

    private abstract class WhereClause<R>
    implements WhereBuilder<R>,
    ConditionBuilder<R>,
    JoinBuilder<R> {
        protected final StringBuilder query;
        protected final List<Object> parameters;

        public WhereClause(StringBuilder query) {
            this(query, new ArrayList<Object>());
        }

        public WhereClause(StringBuilder query, List<Object> parameters) {
            this.query = query;
            this.parameters = parameters;
        }

        protected <T> void addEqualityClause(String column, T value) {
            this.query.append(column);
            this.query.append(" = ");
            if (value != null) {
                this.query.append(QueryBuilderImpl.SQL_PARAMETER_PLACEHOLDER);
                this.parameters.add(value);
            } else {
                this.query.append(QueryBuilderImpl.SQL_NULL);
            }
        }

        protected <T> void addIsClause(String column, T value) {
            this.query.append(column);
            this.query.append(QueryBuilderImpl.SQL_IS);
            if (value != null) {
                this.query.append(QueryBuilderImpl.SQL_PARAMETER_PLACEHOLDER);
                this.parameters.add(value);
            } else {
                this.query.append(QueryBuilderImpl.SQL_NULL);
            }
        }

        protected <T> void addInClause(String column, Collection<T> values) {
            if (!values.isEmpty()) {
                this.query.append(column);
                this.query.append(QueryBuilderImpl.SQL_IN);
                this.query.append(QueryBuilderImpl.OPEN_PARENTHESIS);
                Iterator<T> iterator = values.iterator();
                while (iterator.hasNext()) {
                    this.query.append(QueryBuilderImpl.SQL_PARAMETER_PLACEHOLDER);
                    iterator.next();
                    if (!iterator.hasNext()) continue;
                    this.query.append(QueryBuilderImpl.COMMA);
                }
                this.query.append(QueryBuilderImpl.CLOSE_PARENTHESIS);
                this.parameters.addAll(values);
            }
        }

        @Override
        public ConditionBuilder<R> and() {
            this.query.append(QueryBuilderImpl.SQL_AND);
            return this;
        }

        @Override
        public <T> WhereBuilder<R> eq(Member member, T value) {
            return this.eq(member.outline().pluralName(), member.name(), value);
        }

        @Override
        public <T> WhereBuilder<R> eq(String table, String column, T value) {
            return this.eq(QueryBuilderImpl.qualifiedName(table, column), value);
        }

        @Override
        public <T> WhereBuilder<R> is(String table, String column, T value) {
            return this.is(QueryBuilderImpl.qualifiedName(table, column), value);
        }

        @Override
        public <T> WhereBuilder<R> is(Member member, T value) {
            return this.is(member.outline().pluralName(), member.name(), value);
        }

        @Override
        public <T> WhereBuilder<R> in(String table, String column, Collection<T> values) {
            return this.in(QueryBuilderImpl.qualifiedName(table, column), values);
        }

        @Override
        public <T> WhereBuilder<R> in(Member member, Collection<T> values) {
            return this.in(member.outline().pluralName(), member.name(), values);
        }

        @Override
        public ConditionBuilder<R> where() {
            this.query.append(QueryBuilderImpl.SQL_WHERE);
            return this;
        }

        @Override
        public JoinBuilder<R> leftJoin(String table) {
            this.query.append(QueryBuilderImpl.SQL_LEFT_JOIN);
            this.query.append(table);
            return this;
        }

        @Override
        public JoinBuilder<R> leftJoin(Outline<?> outline) {
            return this.leftJoin(outline.pluralName());
        }

        @Override
        public WhereBuilder<R> onEq(String column1, String column2) {
            this.query.append(QueryBuilderImpl.SQL_ON);
            this.query.append(column1);
            this.query.append(" = ");
            this.query.append(column2);
            return this;
        }

        @Override
        public WhereBuilder<R> onEq(String table1, String column1, String table2, String column2) {
            return this.onEq(QueryBuilderImpl.qualifiedName(table1, column1), QueryBuilderImpl.qualifiedName(table2, column2));
        }

        @Override
        public WhereBuilder<R> onEq(Member member1, Member member2) {
            return this.onEq(member1.outline().pluralName(), member1.name(), member2.outline().pluralName(), member2.name());
        }

        @Override
        public WhereBuilder<R> onEq(String table1, String column1, Member member2) {
            return this.onEq(table1, column1, member2.outline().pluralName(), member2.name());
        }
    }

    private class SelectWhereClause
    extends WhereClause<Observable<Row>> {
        public SelectWhereClause(StringBuilder query) {
            super(query);
        }

        public SelectWhereClause(StringBuilder query, List<Object> parameters) {
            super(query, parameters);
        }

        @Override
        public Observable<Row> all() {
            if (this.parameters.size() > 0) {
                return QueryBuilderImpl.this.query(this.query.toString(), this.parameters.toArray(new Object[this.parameters.size()]));
            }
            return QueryBuilderImpl.this.query(this.query.toString());
        }

        @Override
        public <T> WhereBuilder<Observable<Row>> eq(String column, T value) {
            this.addEqualityClause(column, value);
            return this;
        }

        @Override
        public <T> WhereBuilder<Observable<Row>> is(String column, T value) {
            this.addIsClause(column, value);
            return this;
        }

        @Override
        public <T> WhereBuilder<Observable<Row>> in(String column, Collection<T> values) {
            this.addInClause(column, values);
            return this;
        }

        @Override
        public Observable<Row> execute() {
            return QueryBuilderImpl.this.query(this.query.toString(), this.parameters.toArray(new Object[this.parameters.size()]));
        }
    }

    private class UpdateWhereClause
    extends WhereClause<UpdateQueryExecution> {
        public UpdateWhereClause(StringBuilder query) {
            super(query);
        }

        public UpdateWhereClause(StringBuilder query, List<Object> parameters) {
            super(query, parameters);
        }

        @Override
        public UpdateQueryExecution all() {
            return QueryBuilderImpl.this.update(this.query.toString(), this.parameters.toArray(new Object[this.parameters.size()]));
        }

        @Override
        public <T> WhereBuilder<UpdateQueryExecution> eq(String column, T value) {
            this.addEqualityClause(column, value);
            return this;
        }

        @Override
        public <T> WhereBuilder<UpdateQueryExecution> is(String column, T value) {
            this.addIsClause(column, value);
            return this;
        }

        @Override
        public <T> WhereBuilder<UpdateQueryExecution> in(String column, Collection<T> values) {
            this.addInClause(column, values);
            return this;
        }

        @Override
        public UpdateQueryExecution execute() {
            return QueryBuilderImpl.this.update(this.query.toString(), this.parameters.toArray(new Object[this.parameters.size()]));
        }
    }

    private class InsertQuerySuffixBuilder
    implements InsertSuffixBuilder {
        private final StringBuilder query;
        private final List<Object> parameters;

        public InsertQuerySuffixBuilder(StringBuilder query, List<Object> parameters) {
            this.query = query;
            this.parameters = parameters;
        }

        private UpdateQueryExecution executeQuery() {
            return QueryBuilderImpl.this.update(this.query.toString(), this.parameters.toArray(new Object[this.parameters.size()]));
        }

        @Override
        public Observable<Integer> count() {
            return this.executeQuery().count();
        }

        @Override
        public Observable<Long> getIds() {
            return this.executeQuery().getIds();
        }

        @Override
        public UpdateQueryExecution onDuplicateKeyUpdate(Function<RowBuilder, Map<String, ?>> rowConstructor) {
            return this.onDuplicateKeyUpdate(rowConstructor.apply(new RowBuilderImpl()));
        }

        @Override
        public UpdateQueryExecution onDuplicateKeyUpdate(Map<String, ?> values) {
            if (values.size() > 0) {
                this.query.append(QueryBuilderImpl.SQL_ON_DUPLICATE_KEY_UPDATE);
                QueryBuilderImpl.appendUpdateAssignments(this.query, this.parameters, values);
            }
            return this;
        }
    }

    private class InsertQuery
    implements InsertBuilder {
        private final StringBuilder query = new StringBuilder();

        public InsertQuery(String table) {
            this.query.append(QueryBuilderImpl.SQL_INSERT_INTO);
            this.query.append(table);
        }

        @Override
        public InsertSuffixBuilder row(Function<RowBuilder, Map<String, ?>> constructor) {
            return this.values(constructor.apply(new RowBuilderImpl()));
        }

        @Override
        public <T> InsertSuffixBuilder values(Collection<T> values, BiFunction<RowBuilder, T, Map<String, ?>> constructor) {
            ArrayList rows = new ArrayList(values.size());
            for (T value : values) {
                Map<String, ?> row = constructor.apply(new RowBuilderImpl(), (RowBuilder)value);
                rows.add(row);
            }
            return this.values(rows.toArray(new Map[rows.size()]));
        }

        @Override
        public InsertSuffixBuilder values(Map<String, ?> ... rows) {
            if (rows.length < 1) {
                return EMPTY_UPDATE_BUILDER;
            }
            LinkedHashSet<String> columns = new LinkedHashSet<String>();
            for (Map<String, ?> row : rows) {
                columns.addAll(row.keySet());
            }
            int numColumns = columns.size();
            if (numColumns < 1) {
                return EMPTY_UPDATE_BUILDER;
            }
            this.query.append(" (");
            Joiner.on((String)", ").appendTo(this.query, columns);
            this.query.append(") VALUES ");
            ArrayList<Object> parameters = new ArrayList<Object>(rows.length * numColumns);
            ArrayList<String> valueSets = new ArrayList<String>(rows.length);
            for (Map<String, ?> row : rows) {
                StringBuilder values = new StringBuilder(QueryBuilderImpl.OPEN_PARENTHESIS);
                int columnIndex = 0;
                for (String column : columns) {
                    Object value = row.get(column);
                    if (value == null) {
                        values.append(QueryBuilderImpl.SQL_NULL);
                    } else {
                        values.append(QueryBuilderImpl.SQL_PARAMETER_PLACEHOLDER);
                        if (value instanceof Temporal) {
                            value = new Timestamp(Times.toEpochMillis((Temporal)value));
                        }
                        parameters.add(value);
                    }
                    if (columnIndex < numColumns - 1) {
                        values.append(", ");
                    }
                    ++columnIndex;
                }
                values.append(')');
                valueSets.add(values.toString());
            }
            Joiner.on((String)", ").appendTo(this.query, valueSets);
            return new InsertQuerySuffixBuilder(this.query, parameters);
        }
    }

    private class UpdateQuery
    implements UpdateBuilder {
        private final List<Object> parameters = new ArrayList<Object>();
        private final StringBuilder query = new StringBuilder();

        public UpdateQuery(String table) {
            this.query.append(QueryBuilderImpl.SQL_UPDATE);
            this.query.append(table);
            this.query.append(QueryBuilderImpl.SQL_SET);
        }

        @Override
        public WhereBuilder<UpdateQueryExecution> set(Map<String, ?> values) {
            if (values.size() < 1) {
                return new UpdateWhereClause(this.query, this.parameters);
            }
            QueryBuilderImpl.appendUpdateAssignments(this.query, this.parameters, values);
            return new UpdateWhereClause(this.query, this.parameters);
        }

        @Override
        public WhereBuilder<UpdateQueryExecution> set(Function<RowBuilder, Map<String, ?>> rowConstructor) {
            return this.set(rowConstructor.apply(new RowBuilderImpl()));
        }
    }
}

