/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.db;

import foundation.stack.datamill.db.DatabaseClient;
import foundation.stack.datamill.reflection.Outline;
import foundation.stack.datamill.reflection.OutlineBuilder;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repository<T> {
    private static final Logger logger = LoggerFactory.getLogger(Repository.class);
    private DatabaseClient client;
    private OutlineBuilder outlineBuilder;
    private Class<T> entityClass;

    protected Repository(DatabaseClient client, OutlineBuilder outlineBuilder, Class<T> entityClass) {
        this.client = client;
        this.outlineBuilder = outlineBuilder;
        this.entityClass = entityClass;
    }

    protected <E> Outline<E> buildOutline(Class<E> entityClass) {
        return this.outlineBuilder.defaultSnakeCased().build(entityClass);
    }

    protected <R> R executeQuery(BiFunction<DatabaseClient, Outline<T>, R> executor) {
        try {
            return executor.apply(this.client, this.buildOutline(this.entityClass));
        }
        catch (Throwable t) {
            logger.debug("An error occurred while building a SQL query!", t);
            throw t;
        }
    }
}

