/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.db;

import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import com.github.davidmoten.rx.jdbc.ConnectionProviderFromDataSource;
import com.github.davidmoten.rx.jdbc.ConnectionProviderPooled;
import com.github.davidmoten.rx.jdbc.Database;
import com.github.davidmoten.rx.jdbc.QueryUpdate;
import foundation.stack.datamill.db.QueryRunner;
import foundation.stack.datamill.db.Row;
import foundation.stack.datamill.db.UpdateQueryExecution;
import foundation.stack.datamill.db.impl.QueryBuilderImpl;
import foundation.stack.datamill.db.impl.RowImpl;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DatabaseClient
extends QueryBuilderImpl
implements QueryRunner {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseClient.class);
    private DelegatingConnectionProvider connectionProvider;
    private final DataSource dataSource;
    private Database database;
    private final String password;
    private final String url;
    private final String username;

    public DatabaseClient(DataSource dataSource) {
        this.dataSource = dataSource;
        this.url = null;
        this.username = null;
        this.password = null;
    }

    public DatabaseClient(String url) {
        this(url, null, null);
    }

    public DatabaseClient(String url, String username, String password) {
        this.dataSource = null;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    private void setupConnectionProvider() {
        if (this.dataSource != null) {
            this.connectionProvider = new DelegatingConnectionProvider((ConnectionProvider)new ConnectionProviderFromDataSource(this.dataSource));
            this.database = Database.from((ConnectionProvider)this.connectionProvider);
        } else if (this.url != null) {
            this.connectionProvider = new DelegatingConnectionProvider((ConnectionProvider)new ConnectionProviderPooled(this.url, this.username, this.password, 0, 10));
            this.database = Database.from((ConnectionProvider)this.connectionProvider);
        }
    }

    private DelegatingConnectionProvider getConnectionProvider() {
        if (this.connectionProvider == null) {
            this.setupConnectionProvider();
        }
        return this.connectionProvider;
    }

    private Database getDatabase() {
        if (this.database == null) {
            this.setupConnectionProvider();
        }
        return this.database;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersion() {
        try (Connection connection = this.getDatabase().getConnectionProvider().get();){
            StringBuilder vendor = new StringBuilder();
            vendor.append(connection.getMetaData().getDatabaseProductName());
            vendor.append(' ');
            vendor.append(connection.getMetaData().getDatabaseProductVersion());
            String string = vendor.toString();
            return string;
        }
        catch (SQLException e) {
            logger.debug("Error retrieving database version information", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getURL() {
        try (Connection connection = this.getDatabase().getConnectionProvider().get();){
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            logger.debug("Error retrieving database connection URL", (Throwable)e);
            return null;
        }
    }

    private Flyway getFlyway() {
        Flyway flyway = new Flyway();
        if (this.dataSource != null) {
            flyway.setDataSource(this.dataSource);
        } else {
            flyway.setDataSource(this.url, this.username, this.password, new String[0]);
        }
        return flyway;
    }

    public void clean() {
        this.getFlyway().clean();
    }

    public void migrate() {
        this.getFlyway().migrate();
    }

    @Override
    public Observable<Row> query(String sql) {
        return this.getDatabase().select(sql).get(resultSet -> new RowImpl(resultSet));
    }

    @Override
    public Observable<Row> query(String sql, Object ... parameters) {
        return this.getDatabase().select(sql).parameters(parameters).get(resultSet -> new RowImpl(resultSet));
    }

    @Override
    public UpdateQueryExecution update(String sql, Object ... parameters) {
        return new UpdateQueryExecutionImpl(this.getDatabase().update(sql).parameters(Observable.from((Object[])parameters)));
    }

    public DatabaseClient changeCatalog(String catalog) {
        this.getConnectionProvider().setCatalog(catalog);
        return this;
    }

    private static class DelegatingConnectionProvider
    implements ConnectionProvider {
        private final ConnectionProvider wrapped;
        private String catalog;

        public DelegatingConnectionProvider(ConnectionProvider wrapped) {
            this.wrapped = wrapped;
        }

        public void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public Connection get() {
            if (this.catalog != null) {
                Connection connection = this.wrapped.get();
                try {
                    connection.setCatalog(this.catalog);
                }
                catch (SQLException e) {
                    logger.debug("Failed to set catalog to {} on SQL connection", (Object)this.catalog);
                }
                return connection;
            }
            return this.wrapped.get();
        }

        public void close() {
            this.wrapped.close();
        }
    }

    private static class UpdateQueryExecutionImpl
    implements UpdateQueryExecution {
        private static final Logger logger = LoggerFactory.getLogger(UpdateQueryExecutionImpl.class);
        private QueryUpdate.Builder updateBuilder;

        public UpdateQueryExecutionImpl(QueryUpdate.Builder updateBuilder) {
            this.updateBuilder = updateBuilder;
        }

        @Override
        public Observable<Integer> count() {
            return this.updateBuilder.count().doOnError(t -> logger.error("Error executing update statement!", t));
        }

        @Override
        public Observable<Long> getIds() {
            return this.updateBuilder.returnGeneratedKeys().getAs(Long.class).doOnError(t -> logger.error("Error executing update statement!", t));
        }
    }
}

