/*
 * Decompiled with CFR 0.152.
 */
package foundation.stack.datamill.configuration;

import foundation.stack.datamill.configuration.SystemPropertyRetriever;
import foundation.stack.datamill.reflection.Bean;
import foundation.stack.datamill.values.StringValue;
import foundation.stack.datamill.values.Value;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action2;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;

public class ConfigurationBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationBuilder.class);
    private final Bean<T> bean;

    public ConfigurationBuilder(Bean<T> bean) {
        this.bean = bean;
    }

    public ConfigurationBuilder<T> configure(Consumer<T> configuration) {
        configuration.accept(this.get());
        return this;
    }

    public ConfigurationBuilder<T> configure(Action2<ConfigurationBuilder<T>, T> configuration) {
        configuration.call((Object)this, this.get());
        return this;
    }

    public T get() {
        return this.bean.unwrap();
    }

    public ConfigurationBuilder<T> ifSystemPropertyExists(String name, Consumer<ConfigurationBuilder<T>> configuration) {
        return this.ifSystemPropertyExists(name, configuration, null);
    }

    public ConfigurationBuilder<T> ifSystemPropertyExists(String name, Consumer<ConfigurationBuilder<T>> configuration, Consumer<ConfigurationBuilder<T>> elseConfiguration) {
        String value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        if (value != null) {
            if (configuration != null) {
                configuration.accept(this);
            }
        } else if (elseConfiguration != null) {
            elseConfiguration.accept(this);
        }
        return this;
    }

    private String getSystemProperty(String name, boolean required) {
        return SystemPropertyRetriever.getSystemProperty(name, required);
    }

    public Value getRequiredSystemProperty(String name) {
        return new StringValue(this.getSystemProperty(name, true));
    }

    private <P> ConfigurationBuilder<T> fromSystemProperty(Consumer<T> propertyInvoker, String name, Func1<String, P> derivation, boolean required) {
        String value = this.getSystemProperty(name, required);
        this.bean.set(propertyInvoker, derivation != null ? derivation.call((Object)value) : value);
        return this;
    }

    public <P> ConfigurationBuilder<T> fromRequiredSystemProperty(Consumer<T> propertyInvoker, String name, Func1<String, P> derivation) {
        return this.fromSystemProperty(propertyInvoker, name, (Object)derivation, true);
    }

    private <P> ConfigurationBuilder<T> fromSystemProperties(Consumer<T> propertyInvoker, String name1, String name2, Func2<String, String, P> derivation, boolean required) {
        String value1 = this.getSystemProperty(name1, required);
        String value2 = this.getSystemProperty(name2, required);
        this.bean.set(propertyInvoker, derivation.call((Object)value1, (Object)value2));
        return this;
    }

    public <P> ConfigurationBuilder<T> fromRequiredSystemProperties(Consumer<T> propertyInvoker, String name1, String name2, Func2<String, String, P> derivation) {
        return this.fromSystemProperties(propertyInvoker, name1, name2, derivation, true);
    }

    private <P> ConfigurationBuilder<T> fromSystemProperties(Consumer<T> propertyInvoker, String name1, String name2, String name3, Func3<String, String, String, P> derivation, boolean required) {
        String value1 = this.getSystemProperty(name1, required);
        String value2 = this.getSystemProperty(name2, required);
        String value3 = this.getSystemProperty(name3, required);
        this.bean.set(propertyInvoker, derivation.call((Object)value1, (Object)value2, (Object)value3));
        return this;
    }

    public <P> ConfigurationBuilder<T> fromRequiredSystemProperties(Consumer<T> propertyInvoker, String name1, String name2, String name3, Func3<String, String, String, P> derivation) {
        return this.fromSystemProperties(propertyInvoker, name1, name2, name3, derivation, true);
    }

    private <P> ConfigurationBuilder<T> fromSystemProperties(Consumer<T> propertyInvoker, String name1, String name2, String name3, String name4, Func4<String, String, String, String, P> derivation, boolean required) {
        String value1 = this.getSystemProperty(name1, required);
        String value2 = this.getSystemProperty(name2, required);
        String value3 = this.getSystemProperty(name3, required);
        String value4 = this.getSystemProperty(name4, required);
        this.bean.set(propertyInvoker, derivation.call((Object)value1, (Object)value2, (Object)value3, (Object)value4));
        return this;
    }

    public <P> ConfigurationBuilder<T> fromRequiredSystemProperties(Consumer<T> propertyInvoker, String name1, String name2, String name3, String name4, Func4<String, String, String, String, P> derivation) {
        return this.fromSystemProperties(propertyInvoker, name1, name2, name3, name4, derivation, true);
    }

    private <P> ConfigurationBuilder<T> fromSystemProperties(Consumer<T> propertyInvoker, String name1, String name2, String name3, String name4, String name5, Func5<String, String, String, String, String, P> derivation, boolean required) {
        String value1 = this.getSystemProperty(name1, required);
        String value2 = this.getSystemProperty(name2, required);
        String value3 = this.getSystemProperty(name3, required);
        String value4 = this.getSystemProperty(name4, required);
        String value5 = this.getSystemProperty(name5, required);
        this.bean.set(propertyInvoker, derivation.call((Object)value1, (Object)value2, (Object)value3, (Object)value4, (Object)value5));
        return this;
    }

    public <P> ConfigurationBuilder<T> fromRequiredSystemProperties(Consumer<T> propertyInvoker, String name1, String name2, String name3, String name4, String name5, Func5<String, String, String, String, String, P> derivation) {
        return this.fromSystemProperties(propertyInvoker, name1, name2, name3, name4, name5, derivation, true);
    }

    private <V> ConfigurationBuilder<T> fromSystemProperty(Consumer<T> propertyInvoker, String name, V defaultValue, boolean required) {
        String value = this.getSystemProperty(name, required);
        if (value != null) {
            this.bean.set(propertyInvoker, new StringValue(value));
        } else {
            this.bean.set(propertyInvoker, defaultValue);
        }
        return this;
    }

    public <V> ConfigurationBuilder<T> fromOptionalSystemProperty(Consumer<T> propertyInvoker, String name, V defaultValue) {
        return this.fromSystemProperty(propertyInvoker, name, defaultValue, false);
    }

    public ConfigurationBuilder<T> fromRequiredSystemProperty(Consumer<T> propertyInvoker, String name) {
        return this.fromRequiredSystemProperty(propertyInvoker, name, null);
    }

    public ConfigurationBuilder<T> fromOptionalSystemProperty(Consumer<T> propertyInvoker, String name) {
        return this.fromSystemProperty(propertyInvoker, name, (Object)null, false);
    }

    public ConfigurationBuilder<T> fromLocalAddress(Consumer<T> propertyInvoker) {
        try {
            this.bean.set(propertyInvoker, InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            logger.debug("Error retrieving local host name, using localhost", (Throwable)e);
            this.bean.set(propertyInvoker, "localhost");
        }
        return this;
    }

    public <P> ConfigurationBuilder<T> fromLocalAddress(Consumer<T> propertyInvoker, Func1<String, P> derivation) {
        String localAddress;
        try {
            localAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.debug("Error retrieving local host name, using localhost", (Throwable)e);
            localAddress = "localhost";
        }
        this.bean.set(propertyInvoker, derivation.call((Object)localAddress));
        return this;
    }

    public ConfigurationBuilder<T> printSystemProperties() {
        StringBuilder properties = new StringBuilder();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            properties.append(entry.getKey() != null ? entry.getKey().toString() : "<null>");
            properties.append("=");
            properties.append(entry.getValue() != null ? entry.getValue().toString() : "<null>");
            properties.append("; ");
        }
        for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
            properties.append(entry.getKey() != null ? (String)entry.getKey() : "<null>");
            properties.append("=");
            properties.append(entry.getValue() != null ? (String)entry.getValue() : "<null>");
            properties.append("; ");
        }
        logger.debug("System Properties: { {} }", (Object)properties);
        return this;
    }
}

