package foundation.stack.datamill.http.impl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import rx.Observable;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * @author Ravi Chodavarapu (rchodava@gmail.com)
 */
public class ServerRequestBuilder {
    public static ServerRequestImpl buildServerRequest(HttpRequest request, Observable<byte[]> entityStream, ExecutorService threadPool) {
        Charset messageCharset = HttpUtil.getCharset(request);
        return new ServerRequestImpl(
                request.method().name(),
                buildHeadersMap(request.headers()),
                request.uri(),
                messageCharset,
                new StreamedChunksEntity(entityStream, messageCharset),
                threadPool);
    }

    public static Multimap<String, String> buildHeadersMap(HttpHeaders headers) {
        Multimap<String, String> headersMap;

        HttpHeaders requestHeaders = headers;
        if (!requestHeaders.isEmpty()) {
            ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();

            for (Map.Entry<String, String> header : requestHeaders) {
                String key = header.getKey();
                String value = header.getValue();

                if (key != null && value != null) {
                    builder.put(key, value);
                }
            }

            headersMap = builder.build();
        } else {
            headersMap = null;
        }

        return headersMap;
    }
}
