/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.example;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.KlayTransactionEncoder;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeCancel;
import org.web3j.example.keySample;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.klaytn.Web3j;
import org.web3j.protocol.klaytn.core.method.response.KlayGetTransactionReceiptResponse;
import org.web3j.protocol.klaytn.core.method.response.TransactionReceipt;
import org.web3j.utils.Numeric;

public class CancelExample
implements keySample {
    public static void run() throws IOException {
        Web3j web3j = Web3j.build((Web3jService)new HttpService("https://public-en-baobab.klaytn.net"));
        KlayCredentials credentials = KlayCredentials.create("0x0e4ca6d38096ad99324de0dde108587e5d7c600165ae4cd6c2462c597458c2b8");
        BigInteger GAS_PRICE = BigInteger.valueOf(50000000000L);
        BigInteger GAS_LIMIT = BigInteger.valueOf(6721950L);
        String from = "0xa2a8854b1802d8cd5de631e690817c253d6a9153";
        EthChainId EthchainId = (EthChainId)web3j.ethChainId().send();
        long chainId = EthchainId.getChainId().longValue();
        BigInteger nonce = ((EthGetTransactionCount)web3j.ethGetTransactionCount(from, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getTransactionCount();
        TxType.Type type = TxType.Type.CANCEL;
        KlayRawTransaction raw = KlayRawTransaction.createTransaction(type, nonce, GAS_PRICE, GAS_LIMIT, from);
        byte[] signedMessage = KlayTransactionEncoder.signMessage(raw, chainId, credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction transactionResponse = (EthSendTransaction)web3j.ethSendRawTransaction(hexValue).send();
        System.out.println("TxHash : \n " + (String)transactionResponse.getResult());
        String txHash = (String)transactionResponse.getResult();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        TransactionReceipt receipt = ((KlayGetTransactionReceiptResponse)web3j.klayGetTransactionReceipt(txHash).send()).getResult();
        System.out.println("receipt : \n" + receipt);
        web3j.shutdown();
        TxTypeCancel rawTransaction = TxTypeCancel.decodeFromRawTransaction(signedMessage);
        System.out.println("TxType : " + rawTransaction.getKlayType());
    }
}

