/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegate;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.KlayTransactionUtils;
import org.web3j.utils.Numeric;

public class TxTypeFeeDelegatedSmartContractDeploy
extends TxTypeFeeDelegate {
    private final byte[] payload;
    private final BigInteger codeFormat;

    public TxTypeFeeDelegatedSmartContractDeploy(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String from, byte[] payload, BigInteger codeFormat) {
        super(type, nonce, gasPrice, gasLimit, from, "", value);
        this.payload = payload;
        this.codeFormat = codeFormat;
    }

    public static TxTypeFeeDelegatedSmartContractDeploy createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String from, byte[] payload, BigInteger codeFormat) {
        return new TxTypeFeeDelegatedSmartContractDeploy(type, nonce, gasPrice, gasLimit, value, from, payload, codeFormat);
    }

    public TxTypeFeeDelegatedSmartContractDeploy(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String from, byte[] payload, BigInteger codeFormat) {
        super(chainId, type, nonce, gasPrice, gasLimit, from, "", value);
        this.payload = payload;
        this.codeFormat = codeFormat;
    }

    public static TxTypeFeeDelegatedSmartContractDeploy createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String from, byte[] payload, BigInteger codeFormat) {
        return new TxTypeFeeDelegatedSmartContractDeploy(chainId, type, nonce, gasPrice, gasLimit, value, from, payload, codeFormat);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public BigInteger getCodeFormat() {
        return this.codeFormat;
    }

    @Override
    public List<RlpType> rlpValues() {
        List<RlpType> values = super.rlpValues();
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        values.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        values.add((RlpType)RlpString.create((byte[])this.getPayload()));
        values.add((RlpType)RlpString.create((long)0L));
        values.add((RlpType)RlpString.create((BigInteger)this.getCodeFormat()));
        return values;
    }

    @Override
    public TxType.Type getKlayType() {
        return TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY;
    }

    public static TxTypeFeeDelegatedSmartContractDeploy decodeFromRawTransaction(byte[] rawTransaction) {
        try {
            byte[] rawTransactionExceptType = KlayTransactionUtils.getRawTransactionNoType(rawTransaction);
            RlpList rlpList = RlpDecoder.decode((byte[])rawTransactionExceptType);
            List values = ((RlpList)rlpList.getValues().get(0)).getValues();
            BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
            BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
            BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
            BigInteger value = ((RlpString)values.get(4)).asPositiveBigInteger();
            String from = ((RlpString)values.get(5)).asString();
            byte[] payload = ((RlpString)values.get(6)).getBytes();
            BigInteger codeFormat = ((RlpString)values.get(8)).asPositiveBigInteger();
            TxType.Type type = TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY;
            TxTypeFeeDelegatedSmartContractDeploy tx = new TxTypeFeeDelegatedSmartContractDeploy(type, nonce, gasPrice, gasLimit, value, from, payload, codeFormat);
            tx.addSignatureData(values, 9);
            return tx;
        }
        catch (Exception e) {
            throw new RuntimeException("There is a error in the processing of decoding tx");
        }
    }

    public static TxTypeFeeDelegatedSmartContractDeploy decodeFromRawTransaction(String rawTransaction) {
        return TxTypeFeeDelegatedSmartContractDeploy.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        throw new UnsupportedOperationException("Unimplemented method 'asRlpValues'");
    }

    public String getData() {
        throw new UnsupportedOperationException("Unimplemented method 'getData'");
    }

    public TransactionType getType() {
        throw new UnsupportedOperationException("Unimplemented method 'getType'");
    }
}

