/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

public class KlayWalletUtils {
    private static final int CURRENT_VERSION = 3;
    private static final String CIPHER = "aes-128-ctr";
    static final String AES_128_CTR = "pbkdf2";
    static final String SCRYPT = "scrypt";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public KlayCredentials loadKlayCredentials(String password, String source) throws IOException, CipherException {
        return this.loadCredentials(password, new File(source));
    }

    public KlayCredentials loadCredentials(String password, File source) throws IOException, CipherException {
        WalletFile walletFile = (WalletFile)objectMapper.readValue(source, WalletFile.class);
        return KlayCredentials.create(Wallet.decrypt((String)password, (WalletFile)walletFile), walletFile.getAddress());
    }

    public static KlayCredentials loadJsonKlayCredentials(String password, String content) throws IOException, CipherException {
        WalletFile walletFile = (WalletFile)objectMapper.readValue(content, WalletFile.class);
        return KlayCredentials.create(Wallet.decrypt((String)password, (WalletFile)walletFile), walletFile.getAddress());
    }

    public static List<List<KlayCredentials>> loadKlayCredentialsFromV4(String password, String source) throws Exception {
        return KlayWalletUtils.loadKlayCredentialsFromV4(password, new File(source));
    }

    public static List<List<KlayCredentials>> loadKlayCredentialsFromV4(String password, File jsonFile) throws Exception {
        JsonNode rootNode = objectMapper.readTree(jsonFile);
        return KlayWalletUtils.loadKlayCredentialsV4(password, rootNode);
    }

    public static List<List<KlayCredentials>> loadJsonKlayCredentialsFromV4(String password, String content) throws Exception {
        JsonNode rootNode = objectMapper.readTree(content);
        return KlayWalletUtils.loadKlayCredentialsV4(password, rootNode);
    }

    static List<List<KlayCredentials>> loadKlayCredentialsV4(String password, JsonNode rootNode) throws Exception {
        String address = rootNode.get("address").asText();
        ArrayList<List<KlayCredentials>> cryptoLists = new ArrayList<List<KlayCredentials>>();
        JsonNode keyringNode = rootNode.get("keyring");
        if (keyringNode.isArray()) {
            if (keyringNode.has(0) && keyringNode.get(0).isArray()) {
                for (JsonNode arrayNode : keyringNode) {
                    ArrayList<KlayCredentials> cryptos = new ArrayList<KlayCredentials>();
                    for (JsonNode cryptoNode : arrayNode) {
                        WalletFile.Crypto crypto = (WalletFile.Crypto)objectMapper.treeToValue((TreeNode)cryptoNode, WalletFile.Crypto.class);
                        cryptos.add(KlayWalletUtils.decryptKlayCredentials(crypto, password, address));
                    }
                    cryptoLists.add(cryptos);
                }
            } else {
                ArrayList<KlayCredentials> cryptos = new ArrayList<KlayCredentials>();
                for (JsonNode cryptoNode : keyringNode) {
                    WalletFile.Crypto crypto = (WalletFile.Crypto)objectMapper.treeToValue((TreeNode)cryptoNode, WalletFile.Crypto.class);
                    cryptos.add(KlayWalletUtils.decryptKlayCredentials(crypto, password, address));
                }
                cryptoLists.add(cryptos);
            }
        }
        return cryptoLists;
    }

    static KlayCredentials decryptKlayCredentials(WalletFile.Crypto crypto, String password, String address) throws CipherException {
        WalletFile temp = new WalletFile();
        temp.setCrypto(crypto);
        temp.setVersion(3);
        ECKeyPair privkey = Wallet.decrypt((String)password, (WalletFile)temp);
        return KlayCredentials.create(privkey, address);
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

