/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Hash;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.transaction.account.AccountKey;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.service.TxKlaySignServiceImpl;
import org.web3j.service.TxSignService;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.TxHashMismatchException;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;
import org.web3j.utils.TxHashVerifier;

public class KlayRawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    private final TxKlaySignServiceImpl txSignService;
    private final long chainId;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    public KlayRawTransactionManager(Web3j web3j, Credentials credentials, long chainId) {
        super(web3j, credentials.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = new TxKlaySignServiceImpl(credentials);
    }

    public KlayRawTransactionManager(Web3j web3j, KlayCredentials credentials, long chainId) {
        super(web3j, credentials.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = new TxKlaySignServiceImpl(credentials);
    }

    public KlayRawTransactionManager(Web3j web3j, TxSignService txSignService, long chainId) {
        super(web3j, txSignService.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = (TxKlaySignServiceImpl)txSignService;
    }

    public KlayRawTransactionManager(Web3j web3j, KlayCredentials credentials, long chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = new TxKlaySignServiceImpl(credentials);
    }

    public KlayRawTransactionManager(Web3j web3j, Credentials credentials, long chainId, int attempts, long sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = new TxKlaySignServiceImpl(credentials);
    }

    public KlayRawTransactionManager(Web3j web3j, KlayCredentials credentials, long chainId, int attempts, long sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials.getAddress());
        this.web3j = web3j;
        this.chainId = chainId;
        this.txSignService = new TxKlaySignServiceImpl(credentials);
    }

    public KlayRawTransactionManager(Web3j web3j, Credentials credentials) {
        this(web3j, credentials, -1L);
    }

    public KlayRawTransactionManager(Web3j web3j, Credentials credentials, int attempts, int sleepDuration) {
        this(web3j, credentials, -1L, attempts, (long)sleepDuration);
    }

    protected BigInteger getNonce() throws IOException {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)this.web3j.ethGetTransactionCount(this.getFromAddress(), (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send();
        return ethGetTransactionCount.getTransactionCount();
    }

    public TxHashVerifier getTxHashVerifier() {
        return this.txHashVerifier;
    }

    public void setTxHashVerifier(TxHashVerifier txHashVerifier) {
        this.txHashVerifier = txHashVerifier;
    }

    public String sendCall(String to, String data, DefaultBlockParameter defaultBlockParameter) throws IOException {
        EthCall ethCall = (EthCall)this.web3j.ethCall(Transaction.createEthCallTransaction((String)this.getFromAddress(), (String)to, (String)data), defaultBlockParameter).send();
        KlayRawTransactionManager.assertCallNotReverted((EthCall)ethCall);
        return ethCall.getValue();
    }

    public EthGetCode getCode(String contractAddress, DefaultBlockParameter defaultBlockParameter) throws IOException {
        return (EthGetCode)this.web3j.ethGetCode(contractAddress, defaultBlockParameter).send();
    }

    public String sign(KlayRawTransaction rawTransaction) {
        byte[] signedMessage = this.txSignService.sign(rawTransaction, this.chainId);
        return Numeric.toHexString((byte[])signedMessage);
    }

    public EthSendTransaction signAndSend(KlayRawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        String hexValue = this.sign(rawTransaction);
        EthSendTransaction ethSendTransaction = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).send();
        if (ethSendTransaction != null && !ethSendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3((String)hexValue), txHashRemote = ethSendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return ethSendTransaction;
    }

    public String sign(RawTransaction rawTransaction) {
        byte[] signedMessage = this.txSignService.sign(rawTransaction, this.chainId);
        return Numeric.toHexString((byte[])signedMessage);
    }

    public EthSendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        String hexValue = this.sign(rawTransaction);
        EthSendTransaction ethSendTransaction = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).send();
        if (ethSendTransaction != null && !ethSendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3((String)hexValue), txHashRemote = ethSendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return ethSendTransaction;
    }

    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendEIP1559Transaction(long chainId, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((long)chainId, (BigInteger)nonce, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data, (BigInteger)maxPriorityFeePerGas, (BigInteger)maxFeePerGas);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String from, AccountKey accountKey) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, from, accountKey);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String from) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, from);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, to, value, from);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload, BigInteger option) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload, option);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String from, AccountKey accountKey, BigInteger feeRatio) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, from, accountKey, feeRatio);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String from, BigInteger feeRatio) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, from, feeRatio);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, BigInteger feeRatio) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, to, value, from, feeRatio);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload, BigInteger codeFormat, BigInteger feeRatio) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload, codeFormat, feeRatio);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String from, byte[] payload) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, from, payload);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction sendKlayTransaction(TxType.Type type, BigInteger gasPrice, BigInteger gas, String from, byte[] payload, BigInteger feeRatio) throws IOException {
        BigInteger nonce = this.getNonce();
        KlayRawTransaction rawTransaction = KlayRawTransaction.createTransaction(type, nonce, gasPrice, gas, from, payload, feeRatio);
        return this.signAndSend(rawTransaction);
    }
}

