/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.klayAccount;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.web3j.crypto.KlayCredentials;

public class Accounts {
    private final List<KlayCredentials> CredentialLists = new ArrayList<KlayCredentials>();

    public boolean add(KlayCredentials credentials) {
        return this.CredentialLists.add(credentials);
    }

    public boolean add(String privKey) {
        return this.CredentialLists.add(KlayCredentials.create(privKey));
    }

    public boolean remove(KlayCredentials credentials) {
        return this.CredentialLists.remove(credentials);
    }

    public List<KlayCredentials> getList() {
        return this.CredentialLists;
    }

    public List<KlayCredentials> credentialsByKey(BigInteger privKey) {
        ArrayList<KlayCredentials> returnKlayCredentials = new ArrayList<KlayCredentials>();
        for (KlayCredentials element : this.CredentialLists) {
            if (!element.getEcKeyPair().getPrivateKey().equals(privKey)) continue;
            returnKlayCredentials.add(element);
        }
        return returnKlayCredentials;
    }

    public List<KlayCredentials> credentialsByPubKey(BigInteger pubKey) {
        ArrayList<KlayCredentials> returnKlayCredentials = new ArrayList<KlayCredentials>();
        for (KlayCredentials element : this.CredentialLists) {
            if (!element.getEcKeyPair().getPublicKey().equals(pubKey)) continue;
            returnKlayCredentials.add(KlayCredentials.create(element.getEcKeyPair(), element.getAddress()));
        }
        return returnKlayCredentials;
    }

    public List<KlayCredentials> credentialsByAddress(String address) {
        ArrayList<KlayCredentials> returnKlayCredentials = new ArrayList<KlayCredentials>();
        for (KlayCredentials element : this.CredentialLists) {
            if (!address.equals(element.getAddress())) continue;
            returnKlayCredentials.add(element);
        }
        return returnKlayCredentials;
    }
}

