/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.example;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.KlayTransactionEncoder;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.example.keySample;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.klaytn.Web3j;
import org.web3j.protocol.klaytn.core.method.response.KlayRecoverFromTransactionResponse;
import org.web3j.utils.Numeric;

public class RecoverTransactionWithMultiSigExample
implements keySample {
    public static void run() throws IOException {
        Web3j web3j = Web3j.build((Web3jService)new HttpService("https://public-en-baobab.klaytn.net"));
        KlayCredentials credentials1 = KlayCredentials.create("0xa32c30608667d43be2d652bede413f12a649dd1be93440878e7f712d51a6768a", "0x82c6a8d94993d49cfd0c1d30f0f8caa65782cc7e");
        KlayCredentials credentials2 = KlayCredentials.create("0x0e4ca6d38096ad99324de0dde108587e5d7c600165ae4cd6c2462c597458c2b8", "0x82c6a8d94993d49cfd0c1d30f0f8caa65782cc7e");
        KlayCredentials credentials3 = KlayCredentials.create("0xc9668ccd35fc20587aa37a48838b48ccc13cf14dd74c8999dd6a480212d5f7ac", "0x82c6a8d94993d49cfd0c1d30f0f8caa65782cc7e");
        BigInteger GAS_PRICE = BigInteger.valueOf(50000000000L);
        BigInteger GAS_LIMIT = BigInteger.valueOf(6721950L);
        String from = credentials1.getAddress();
        EthChainId EthchainId = (EthChainId)web3j.ethChainId().send();
        long chainId = EthchainId.getChainId().longValue();
        String to = "0x000000000000000000000000000000000000dead";
        BigInteger nonce = ((EthGetTransactionCount)web3j.ethGetTransactionCount(from, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getTransactionCount();
        BigInteger value = BigInteger.valueOf(100L);
        TxType.Type type = TxType.Type.VALUE_TRANSFER;
        KlayRawTransaction raw = KlayRawTransaction.createTransaction(type, nonce, GAS_PRICE, GAS_LIMIT, to, value, from);
        byte[] signedMessage = KlayTransactionEncoder.signMessage(raw, chainId, credentials1);
        signedMessage = KlayTransactionEncoder.signMessage(signedMessage, chainId, credentials2);
        signedMessage = KlayTransactionEncoder.signMessage(signedMessage, chainId, credentials3);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        String blockNumber = "latest";
        KlayRecoverFromTransactionResponse response = (KlayRecoverFromTransactionResponse)web3j.klayRecoverFromTransaction(hexValue, blockNumber).send();
        System.out.println("Original address : " + from);
        System.out.println("Result address : " + response.getResult());
        web3j.shutdown();
    }
}

