/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegate;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.KlayTransactionUtils;
import org.web3j.utils.Numeric;

public class TxTypeFeeDelegatedValueTransferWithRatio
extends TxTypeFeeDelegate {
    private final BigInteger feeRatio;

    protected TxTypeFeeDelegatedValueTransferWithRatio(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String from, BigInteger feeRatio) {
        super(type, nonce, gasPrice, gasLimit, from, to, value);
        this.feeRatio = feeRatio;
    }

    public static TxTypeFeeDelegatedValueTransferWithRatio createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String from, BigInteger feeRatio) {
        return new TxTypeFeeDelegatedValueTransferWithRatio(type, nonce, gasPrice, gasLimit, to, value, from, feeRatio);
    }

    protected TxTypeFeeDelegatedValueTransferWithRatio(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String from, BigInteger feeRatio) {
        super(chainId, type, nonce, gasPrice, gasLimit, from, to, value);
        this.feeRatio = feeRatio;
    }

    public static TxTypeFeeDelegatedValueTransferWithRatio createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String from, BigInteger feeRatio) {
        return new TxTypeFeeDelegatedValueTransferWithRatio(chainId, type, nonce, gasPrice, gasLimit, to, value, from, feeRatio);
    }

    @Override
    public BigInteger getFeeRatio() {
        return this.feeRatio;
    }

    @Override
    public List<RlpType> rlpValues() {
        List<RlpType> values = super.rlpValues();
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        values.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        values.add((RlpType)RlpString.create((BigInteger)this.getFeeRatio()));
        return values;
    }

    @Override
    public TxType.Type getKlayType() {
        return TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO;
    }

    public static TxTypeFeeDelegatedValueTransferWithRatio decodeFromRawTransaction(byte[] rawTransaction) {
        try {
            byte[] rawTransactionExceptType = KlayTransactionUtils.getRawTransactionNoType(rawTransaction);
            RlpList rlpList = RlpDecoder.decode((byte[])rawTransactionExceptType);
            List values = ((RlpList)rlpList.getValues().get(0)).getValues();
            BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
            BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
            BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
            String to = ((RlpString)values.get(3)).asString();
            BigInteger value = ((RlpString)values.get(4)).asPositiveBigInteger();
            String from = ((RlpString)values.get(5)).asString();
            BigInteger feeRatio = ((RlpString)values.get(6)).asPositiveBigInteger();
            TxType.Type type = TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO;
            TxTypeFeeDelegatedValueTransferWithRatio tx = TxTypeFeeDelegatedValueTransferWithRatio.createTransaction(type, nonce, gasPrice, gasLimit, to, value, from, feeRatio);
            tx.addSignatureData(values, 7);
            return tx;
        }
        catch (Exception e) {
            throw new RuntimeException("There is a error in the processing of decoding tx");
        }
    }

    public static TxTypeFeeDelegatedValueTransferWithRatio decodeFromRawTransaction(String rawTransaction) {
        return TxTypeFeeDelegatedValueTransferWithRatio.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        throw new UnsupportedOperationException("Unimplemented method 'asRlpValues'");
    }

    public String getData() {
        throw new UnsupportedOperationException("Unimplemented method 'getData'");
    }

    public TransactionType getType() {
        throw new UnsupportedOperationException("Unimplemented method 'getType'");
    }
}

