/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.Sign;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Bytes;
import org.web3j.utils.BytesUtils;
import org.web3j.utils.Numeric;

public class KlaySignatureData {
    private byte[] v;
    private byte[] r;
    private byte[] s;

    public KlaySignatureData() {
    }

    public KlaySignatureData(byte[] v, byte[] r, byte[] s) {
        this.v = v;
        this.r = r;
        this.s = s;
    }

    public static KlaySignatureData getEmptySignature() {
        KlaySignatureData emptySig = new KlaySignatureData(Numeric.hexStringToByteArray((String)"0x01"), Numeric.hexStringToByteArray((String)"0x"), Numeric.hexStringToByteArray((String)"0x"));
        return emptySig;
    }

    public static List<KlaySignatureData> decodeSignatures(List<RlpType> signatureRlpTypeList) {
        ArrayList<KlaySignatureData> signatureDataList = new ArrayList<KlaySignatureData>();
        for (RlpType signature : signatureRlpTypeList) {
            List vrs = ((RlpList)signature).getValues();
            if (vrs.size() < 3) continue;
            byte[] v = ((RlpString)vrs.get(0)).getBytes();
            byte[] r = ((RlpString)vrs.get(1)).getBytes();
            byte[] s = ((RlpString)vrs.get(2)).getBytes();
            signatureDataList.add(new KlaySignatureData(v, r, s));
        }
        return signatureDataList;
    }

    public byte[] getV() {
        return this.v;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KlaySignatureData that = (KlaySignatureData)o;
        if (!Arrays.equals(this.v, that.v)) {
            return false;
        }
        if (!Arrays.equals(this.r, that.r)) {
            return false;
        }
        return Arrays.equals(this.s, that.s);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.v);
        result = 31 * result + Arrays.hashCode(this.r);
        result = 31 * result + Arrays.hashCode(this.s);
        return result;
    }

    public String toString() {
        return "V : " + Numeric.toBigInt((byte[])this.getV()) + "\nR : " + Numeric.toBigInt((byte[])this.getR()) + "\nS : " + Numeric.toBigInt((byte[])this.getS());
    }

    public static KlaySignatureData createKlaySignatureDataFromChainId(long chainId) {
        return new KlaySignatureData(BigInteger.valueOf(chainId).toByteArray(), new byte[0], new byte[0]);
    }

    public RlpList toRlpList() {
        return new RlpList(new RlpType[]{RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])this.getV())), RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])this.getR())), RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])this.getS()))});
    }

    public static KlaySignatureData createEip155KlaySignatureData(Sign.SignatureData signatureData, long chainId) {
        long v = (long)Numeric.toBigInt((byte[])signatureData.getV()).intValue() + chainId * 2L + 8L;
        return new KlaySignatureData(BigInteger.valueOf(v).toByteArray(), signatureData.getR(), signatureData.getS());
    }

    public static byte[] getKlaytnMessageHash(String message) {
        String preamble = "\u0019Klaytn Signed Message:\n";
        byte[] messageArr = BytesUtils.isHexStrict(message) ? Numeric.hexStringToByteArray((String)message) : message.getBytes();
        byte[] preambleArr = "\u0019Klaytn Signed Message:\n".concat(String.valueOf(messageArr.length)).getBytes();
        byte[] klayMessage = BytesUtils.concat(preambleArr, messageArr);
        byte[] result = Hash.sha3((byte[])klayMessage);
        return result;
    }

    public static Sign.SignatureData signPrefixedMessage(String message, KlayCredentials cred) {
        byte[] messageBytes = KlaySignatureData.getKlaytnMessageHash(message);
        return Sign.signMessage((byte[])messageBytes, (ECKeyPair)cred.getEcKeyPair(), (boolean)false);
    }

    public static String getSignatureString(Sign.SignatureData signature) {
        byte[] retval = new byte[65];
        System.arraycopy(signature.getR(), 0, retval, 0, 32);
        System.arraycopy(signature.getS(), 0, retval, 32, 32);
        System.arraycopy(signature.getV(), 0, retval, 64, 1);
        return Numeric.toHexString((byte[])retval);
    }
}

