/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.example;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Uint;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.KlayTransactionEncoder;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractExecution;
import org.web3j.example.keySample;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.klaytn.Web3j;
import org.web3j.protocol.klaytn.core.method.response.KlayGetTransactionReceiptResponse;
import org.web3j.protocol.klaytn.core.method.response.TransactionReceipt;
import org.web3j.utils.Numeric;

public class InteractWithContractAndFeeDelegateExample
implements keySample {
    public static void run() throws IOException {
        Web3j web3j = Web3j.build((Web3jService)new HttpService("https://public-en-baobab.klaytn.net"));
        KlayCredentials credentials = KlayCredentials.create("0x0e4ca6d38096ad99324de0dde108587e5d7c600165ae4cd6c2462c597458c2b8");
        KlayCredentials credentials_feepayer = KlayCredentials.create("0x9435261ed483b6efa3886d6ad9f64c12078a0e28d8d80715c773e16fc000cff4");
        String contractAddress = "0x8a717ca7D1f620290D3D7535108A17D73253402d";
        BigInteger GAS_PRICE = BigInteger.valueOf(50000000000L);
        BigInteger GAS_LIMIT = BigInteger.valueOf(6721950L);
        String from = credentials.getAddress();
        BigInteger nonce = ((EthGetTransactionCount)web3j.ethGetTransactionCount(from, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getTransactionCount();
        EthChainId EthchainId = (EthChainId)web3j.ethChainId().send();
        long chainId = EthchainId.getChainId().longValue();
        BigInteger value = BigInteger.ZERO;
        Function function = new Function("set", Arrays.asList(new Uint(BigInteger.valueOf(50L))), Collections.emptyList());
        String txData = FunctionEncoder.encode((Function)function);
        byte[] payload = Numeric.hexStringToByteArray((String)txData);
        TxType.Type type = TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION;
        KlayRawTransaction raw = KlayRawTransaction.createTransaction(type, nonce, GAS_PRICE, GAS_LIMIT, contractAddress, value, from, payload);
        byte[] signedMessage = KlayTransactionEncoder.signMessage(raw, chainId, credentials);
        signedMessage = KlayTransactionEncoder.signMessageAsFeePayer(raw, chainId, credentials_feepayer);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction transactionResponse = (EthSendTransaction)web3j.ethSendRawTransaction(hexValue).send();
        System.out.println("TxHash : \n " + (String)transactionResponse.getResult());
        String txHash = (String)transactionResponse.getResult();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        TransactionReceipt receipt = ((KlayGetTransactionReceiptResponse)web3j.klayGetTransactionReceipt(txHash).send()).getResult();
        System.out.println("receipt : \n" + receipt);
        web3j.shutdown();
        TxTypeFeeDelegatedSmartContractExecution rawTransaction = TxTypeFeeDelegatedSmartContractExecution.decodeFromRawTransaction(signedMessage);
        System.out.println("TxType : " + rawTransaction.getKlayType());
    }
}

