/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayWalletUtils;
import org.web3j.example.keySample;

public class DecryptKeystoreV3Example
implements keySample {
    public static void run() throws Exception {
        String[] keyFiles;
        String password = "Iloveklaytn";
        for (String keyFile : keyFiles = new String[]{"/Legacy_V3.json", "/Public_V3.json"}) {
            String json = DecryptKeystoreV3Example.getResourceJSON(keyFile);
            KlayCredentials credentials = KlayWalletUtils.loadJsonKlayCredentials(password, json);
            System.out.println("Load KlayCredentials from keystore file: " + keyFile);
            String address = credentials.getAddress();
            String privateKey = credentials.getEcKeyPair().getPrivateKey().toString(16);
            System.out.println("\tKlayCrendential : Address: " + address + ", Private Key: 0x" + privateKey);
        }
    }

    static String getResourceJSON(String resourcePath) throws IOException {
        String string;
        InputStream inputStream = DecryptKeystoreV3Example.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new IllegalArgumentException("resource not found: " + resourcePath);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return string;
    }
}

