/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegate;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.KlayTransactionUtils;
import org.web3j.utils.Numeric;

public class TxTypeFeeDelegatedSmartContractDeployWithRatio
extends TxTypeFeeDelegate {
    private final byte[] payload;
    private final BigInteger feeRatio;
    private final BigInteger codeFormat;

    public TxTypeFeeDelegatedSmartContractDeployWithRatio(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String from, byte[] payload, BigInteger feeRatio, BigInteger codeFormat) {
        super(type, nonce, gasPrice, gasLimit, from, "", value);
        this.payload = payload;
        this.feeRatio = feeRatio;
        this.codeFormat = codeFormat;
    }

    public static TxTypeFeeDelegatedSmartContractDeployWithRatio createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String from, byte[] payload, BigInteger feeRatio, BigInteger codeFormat) {
        return new TxTypeFeeDelegatedSmartContractDeployWithRatio(type, nonce, gasPrice, gasLimit, value, from, payload, feeRatio, codeFormat);
    }

    public TxTypeFeeDelegatedSmartContractDeployWithRatio(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String from, byte[] payload, BigInteger feeRatio, BigInteger codeFormat) {
        super(chainId, type, nonce, gasPrice, gasLimit, from, "", value);
        this.payload = payload;
        this.feeRatio = feeRatio;
        this.codeFormat = codeFormat;
    }

    public static TxTypeFeeDelegatedSmartContractDeployWithRatio createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String from, byte[] payload, BigInteger feeRatio, BigInteger codeFormat) {
        return new TxTypeFeeDelegatedSmartContractDeployWithRatio(chainId, type, nonce, gasPrice, gasLimit, value, from, payload, feeRatio, codeFormat);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public BigInteger getFeeRatio() {
        return this.feeRatio;
    }

    public BigInteger getCodeFormat() {
        return this.codeFormat;
    }

    @Override
    public List<RlpType> rlpValues() {
        List<RlpType> values = super.rlpValues();
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        values.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        values.add((RlpType)RlpString.create((byte[])this.getPayload()));
        values.add((RlpType)RlpString.create((long)0L));
        values.add((RlpType)RlpString.create((BigInteger)this.getFeeRatio()));
        values.add((RlpType)RlpString.create((BigInteger)this.getCodeFormat()));
        return values;
    }

    @Override
    public TxType.Type getKlayType() {
        return TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO;
    }

    public static TxTypeFeeDelegatedSmartContractDeployWithRatio decodeFromRawTransaction(byte[] rawTransaction) {
        try {
            byte[] rawTransactionExceptType = KlayTransactionUtils.getRawTransactionNoType(rawTransaction);
            RlpList rlpList = RlpDecoder.decode((byte[])rawTransactionExceptType);
            List values = ((RlpList)rlpList.getValues().get(0)).getValues();
            BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
            BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
            BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
            BigInteger value = ((RlpString)values.get(4)).asPositiveBigInteger();
            String from = ((RlpString)values.get(5)).asString();
            byte[] payload = ((RlpString)values.get(6)).getBytes();
            BigInteger feeRatio = ((RlpString)values.get(8)).asPositiveBigInteger();
            BigInteger codeFormat = ((RlpString)values.get(9)).asPositiveBigInteger();
            TxType.Type type = TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO;
            TxTypeFeeDelegatedSmartContractDeployWithRatio tx = new TxTypeFeeDelegatedSmartContractDeployWithRatio(type, nonce, gasPrice, gasLimit, value, from, payload, feeRatio, codeFormat);
            tx.addSignatureData(values, 10);
            return tx;
        }
        catch (Exception e) {
            throw new RuntimeException("There is a error in the processing of decoding tx");
        }
    }

    public static TxTypeFeeDelegatedSmartContractDeployWithRatio decodeFromRawTransaction(String rawTransaction) {
        return TxTypeFeeDelegatedSmartContractDeployWithRatio.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        throw new UnsupportedOperationException("Unimplemented method 'asRlpValues'");
    }

    public String getData() {
        throw new UnsupportedOperationException("Unimplemented method 'getData'");
    }

    public TransactionType getType() {
        throw new UnsupportedOperationException("Unimplemented method 'getType'");
    }
}

