/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegate;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.KlayTransactionUtils;
import org.web3j.utils.Numeric;

public class TxTypeFeeDelegatedChainDataAnchoringWithRatio
extends TxTypeFeeDelegate {
    private final byte[] anchoredData;
    private final BigInteger feeRatio;

    protected TxTypeFeeDelegatedChainDataAnchoringWithRatio(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData, BigInteger feeRatio) {
        super(type, nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.anchoredData = anchoredData;
        this.feeRatio = feeRatio;
    }

    public static TxTypeFeeDelegatedChainDataAnchoringWithRatio createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData, BigInteger feeRatio) {
        return new TxTypeFeeDelegatedChainDataAnchoringWithRatio(type, nonce, gasPrice, gasLimit, from, anchoredData, feeRatio);
    }

    protected TxTypeFeeDelegatedChainDataAnchoringWithRatio(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData, BigInteger feeRatio) {
        super(chainId, type, nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.anchoredData = anchoredData;
        this.feeRatio = feeRatio;
    }

    public static TxTypeFeeDelegatedChainDataAnchoringWithRatio createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, byte[] anchoredData, BigInteger feeRatio) {
        return new TxTypeFeeDelegatedChainDataAnchoringWithRatio(chainId, type, nonce, gasPrice, gasLimit, from, anchoredData, feeRatio);
    }

    public byte[] getAnchoredData() {
        return this.anchoredData;
    }

    @Override
    public List<RlpType> rlpValues() {
        List<RlpType> values = super.rlpValues();
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        values.add((RlpType)RlpString.create((byte[])this.getAnchoredData()));
        return values;
    }

    @Override
    public TxType.Type getKlayType() {
        return TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO;
    }

    public static TxTypeFeeDelegatedChainDataAnchoringWithRatio decodeFromRawTransaction(byte[] rawTransaction) {
        byte[] rawTransactionExceptType = KlayTransactionUtils.getRawTransactionNoType(rawTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])rawTransactionExceptType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
        String from = ((RlpString)values.get(3)).asString();
        byte[] payload = ((RlpString)values.get(4)).getBytes();
        BigInteger feeRatio = ((RlpString)values.get(5)).asPositiveBigInteger();
        TxType.Type type = TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO;
        TxTypeFeeDelegatedChainDataAnchoringWithRatio tx = new TxTypeFeeDelegatedChainDataAnchoringWithRatio(type, nonce, gasPrice, gasLimit, from, payload, feeRatio);
        tx.addSignatureData(values, 6);
        return tx;
    }

    public static TxTypeFeeDelegatedChainDataAnchoringWithRatio decodeFromRawTransaction(String rawTransaction) {
        return TxTypeFeeDelegatedChainDataAnchoringWithRatio.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        return null;
    }

    public String getData() {
        return null;
    }

    public TransactionType getType() {
        return null;
    }
}

