/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.KlaySignatureData;
import org.web3j.crypto.transaction.type.AbstractTxType;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.BytesUtils;
import org.web3j.utils.Numeric;

public abstract class TxTypeFeeDelegate
extends AbstractTxType {
    static final String EMPTY_FEE_PAYER_ADDRESS = "0x30";
    static final int DEFAULT_FEE_RATIO = 100;
    private Set<KlaySignatureData> feePayerSignatureData = new HashSet<KlaySignatureData>();
    private String feePayer = "0x30";

    public TxTypeFeeDelegate(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, String to, BigInteger value) {
        super(type, nonce, gasPrice, gasLimit, from, to, value);
    }

    public TxTypeFeeDelegate(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, String to, BigInteger value) {
        super(chainId, type, nonce, gasPrice, gasLimit, from, to, value);
    }

    public Set<KlaySignatureData> getFeePayerSignatureData() {
        return this.feePayerSignatureData;
    }

    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public BigInteger getFeeRatio() {
        return BigInteger.valueOf(100L);
    }

    public void addFeePayerSignatureData(KlaySignatureData feePayerSignatureData) {
        this.feePayerSignatureData.add(feePayerSignatureData);
    }

    public void addFeePayerSignatureData(Set<KlaySignatureData> feePayerSignatureData) {
        this.feePayerSignatureData.addAll(feePayerSignatureData);
    }

    protected void addFeePayerSignatureData(List<RlpType> signatureRlpTypeList) {
        for (RlpType signatureRlpType : signatureRlpTypeList) {
            List vrs = ((RlpList)signatureRlpType).getValues();
            if (vrs.size() < 3) continue;
            byte[] v = ((RlpString)vrs.get(0)).getBytes();
            byte[] r = ((RlpString)vrs.get(1)).getBytes();
            byte[] s = ((RlpString)vrs.get(2)).getBytes();
            this.addFeePayerSignatureData(new KlaySignatureData(v, r, s));
        }
    }

    @Override
    public void addSignatureData(List<RlpType> values, int offset) {
        if (values.size() > offset) {
            List senderSignatures = ((RlpList)values.get(offset)).getValues();
            this.addSenderSignatureData(senderSignatures);
        }
        if (values.size() > offset + 1) {
            String feePayer = ((RlpString)values.get(offset + 1)).asString();
            this.setFeePayer(feePayer);
        }
        if (values.size() > offset + 2) {
            List feePayerSignatures = ((RlpList)values.get(offset + 2)).getValues();
            this.addFeePayerSignatureData(feePayerSignatures);
        }
    }

    public void addSignatureData(TxTypeFeeDelegate txType) {
        this.addSenderSignatureData(txType.getSenderSignatureDataSet());
        this.addFeePayerSignatureData(txType.getSenderSignatureDataSet());
    }

    @Override
    public KlayRawTransaction sign(KlayCredentials credentials, long chainId) {
        Set<KlaySignatureData> newSignatureDataSet = this.getNewSenderSignatureDataSet(credentials, chainId);
        this.addSenderSignatureData(newSignatureDataSet);
        ArrayList<RlpType> rlpTypeList = new ArrayList<RlpType>(this.rlpValues());
        ArrayList<RlpList> senderSignatureList = new ArrayList<RlpList>();
        for (KlaySignatureData klaySignatureData : this.getSenderSignatureDataSet()) {
            senderSignatureList.add(klaySignatureData.toRlpList());
        }
        rlpTypeList.add((RlpType)new RlpList(senderSignatureList));
        rlpTypeList.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.feePayer)));
        ArrayList<RlpList> feePayerSignatureList = new ArrayList<RlpList>();
        for (KlaySignatureData klaySignatureData : this.feePayerSignatureData) {
            feePayerSignatureList.add(klaySignatureData.toRlpList());
        }
        rlpTypeList.add((RlpType)new RlpList(feePayerSignatureList));
        byte[] byArray = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{this.getKlayType().get()};
        byte[] rawTx = BytesUtils.concat(type, byArray);
        return new KlayRawTransaction((ITransaction)this, rawTx, this.getSenderSignatureData());
    }
}

