/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.web3j.crypto.KlaySignatureData;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.transaction.account.AccountKey;
import org.web3j.crypto.transaction.type.AbstractTxType;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.crypto.transaction.type.TxTypeAccountUpdate;
import org.web3j.crypto.transaction.type.TxTypeCancel;
import org.web3j.crypto.transaction.type.TxTypeChainDataAnchoring;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedAccountUpdate;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedAccountUpdateWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedCancel;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedCancelWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedChainDataAnchoring;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedChainDataAnchoringWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractDeploy;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractDeployWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractExecution;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedSmartContractExecutionWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransfer;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferMemo;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferMemoWithRatio;
import org.web3j.crypto.transaction.type.TxTypeFeeDelegatedValueTransferWithRatio;
import org.web3j.crypto.transaction.type.TxTypeSmartContractDeploy;
import org.web3j.crypto.transaction.type.TxTypeSmartContractExecution;
import org.web3j.crypto.transaction.type.TxTypeValueTransfer;
import org.web3j.crypto.transaction.type.TxTypeValueTransferMemo;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.klaytn.Web3j;
import org.web3j.protocol.klaytn.core.method.response.KlayGasPriceResponse;
import org.web3j.utils.Numeric;

public class KlayRawTransaction
extends RawTransaction {
    private byte[] value;
    private Set<KlaySignatureData> signatureData;

    public KlayRawTransaction(ITransaction transaction, Set<KlaySignatureData> signatureData) {
        super(transaction);
        this.signatureData = signatureData;
    }

    public KlayRawTransaction(ITransaction transaction, KlaySignatureData signatureData) {
        super(transaction);
        this.signatureData = new HashSet<KlaySignatureData>(Arrays.asList(signatureData));
    }

    public KlayRawTransaction(ITransaction transaction, byte[] value, Set<KlaySignatureData> signatureData) {
        super(transaction);
        this.value = value;
        this.signatureData = signatureData;
    }

    public KlayRawTransaction(ITransaction transaction, byte[] value, KlaySignatureData signatureData) {
        super(transaction);
        this.value = value;
        this.signatureData = new HashSet<KlaySignatureData>(Arrays.asList(signatureData));
    }

    public KlaySignatureData getSignatureData() {
        try {
            return this.signatureData.iterator().next();
        }
        catch (Exception e) {
            throw new RuntimeException("Called without signature data");
        }
    }

    protected KlayRawTransaction(ITransaction transaction) {
        super(transaction);
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, AccountKey accountKey) {
        if (type == TxType.Type.ACCOUNT_UPDATE) {
            return new KlayRawTransaction(TxTypeAccountUpdate.createTransaction(type, nonce, gasPrice, gas, from, accountKey));
        }
        if (type == TxType.Type.FEE_DELEGATED_ACCOUNT_UPDATE) {
            return new KlayRawTransaction(TxTypeFeeDelegatedAccountUpdate.createTransaction(type, nonce, gasPrice, gas, from, accountKey));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from) {
        if (type == TxType.Type.CANCEL) {
            return new KlayRawTransaction(TxTypeCancel.createTransaction(type, nonce, gasPrice, gas, from));
        }
        if (type == TxType.Type.FEE_DELEGATED_CANCEL) {
            return new KlayRawTransaction(TxTypeFeeDelegatedCancel.createTransaction(type, nonce, gasPrice, gas, from));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from) {
        if (type == TxType.Type.VALUE_TRANSFER) {
            return new KlayRawTransaction(TxTypeValueTransfer.createTransaction(type, nonce, gasPrice, gas, to, value, from));
        }
        if (type == TxType.Type.FEE_DELEGATED_VALUE_TRANSFER) {
            return new KlayRawTransaction(TxTypeFeeDelegatedValueTransfer.createTransaction(type, nonce, gasPrice, gas, to, value, from));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload) {
        if (type == TxType.Type.VALUE_TRANSFER_MEMO) {
            return new KlayRawTransaction(TxTypeValueTransferMemo.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload));
        }
        if (type == TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedValueTransferMemo.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload));
        }
        if (type == TxType.Type.SMART_CONTRACT_EXECUTION) {
            return new KlayRawTransaction(TxTypeSmartContractExecution.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload));
        }
        if (type == TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION) {
            return new KlayRawTransaction(TxTypeFeeDelegatedSmartContractExecution.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload, BigInteger option) {
        if (type == TxType.Type.SMART_CONTRACT_DEPLOY) {
            return new KlayRawTransaction(TxTypeSmartContractDeploy.createTransaction(type, nonce, gasPrice, gas, value, from, payload, option));
        }
        if (type == TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY) {
            return new KlayRawTransaction(TxTypeFeeDelegatedSmartContractDeploy.createTransaction(type, nonce, gasPrice, gas, value, from, payload, option));
        }
        if (type == TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedValueTransferMemoWithRatio.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload, option));
        }
        if (type == TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedSmartContractExecutionWithRatio.createTransaction(type, nonce, gasPrice, gas, to, value, from, payload, option));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, AccountKey accountKey, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_ACCOUNT_UPDATE_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedAccountUpdateWithRatio.createTransaction(type, nonce, gasPrice, gas, from, accountKey, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_CANCEL_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedCancelWithRatio.createTransaction(type, nonce, gasPrice, gas, from, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedValueTransferWithRatio.createTransaction(type, nonce, gasPrice, gas, to, value, from, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload, BigInteger codeFormat, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedSmartContractDeployWithRatio.createTransaction(type, nonce, gasPrice, gas, value, from, payload, codeFormat, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, byte[] payload) {
        if (type == TxType.Type.CHAIN_DATA_ANCHORING) {
            return new KlayRawTransaction(TxTypeChainDataAnchoring.createTransaction(type, nonce, gasPrice, gas, from, payload));
        }
        if (type == TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING) {
            return new KlayRawTransaction(TxTypeFeeDelegatedChainDataAnchoring.createTransaction(type, nonce, gasPrice, gas, from, payload));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, byte[] payload, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedChainDataAnchoringWithRatio.createTransaction(type, nonce, gasPrice, gas, from, payload, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, AccountKey accountKey) {
        if (type == TxType.Type.ACCOUNT_UPDATE) {
            return new KlayRawTransaction(TxTypeAccountUpdate.createTransaction(chainId, type, nonce, gasPrice, gas, from, accountKey));
        }
        if (type == TxType.Type.FEE_DELEGATED_ACCOUNT_UPDATE) {
            return new KlayRawTransaction(TxTypeFeeDelegatedAccountUpdate.createTransaction(chainId, type, nonce, gasPrice, gas, from, accountKey));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from) {
        if (type == TxType.Type.CANCEL) {
            return new KlayRawTransaction(TxTypeCancel.createTransaction(chainId, type, nonce, gasPrice, gas, from));
        }
        if (type == TxType.Type.FEE_DELEGATED_CANCEL) {
            return new KlayRawTransaction(TxTypeFeeDelegatedCancel.createTransaction(chainId, type, nonce, gasPrice, gas, from));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from) {
        if (type == TxType.Type.VALUE_TRANSFER) {
            return new KlayRawTransaction(TxTypeValueTransfer.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from));
        }
        if (type == TxType.Type.FEE_DELEGATED_VALUE_TRANSFER) {
            return new KlayRawTransaction(TxTypeFeeDelegatedValueTransfer.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload) {
        if (type == TxType.Type.VALUE_TRANSFER_MEMO) {
            return new KlayRawTransaction(TxTypeValueTransferMemo.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from, payload));
        }
        if (type == TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedValueTransferMemo.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from, payload));
        }
        if (type == TxType.Type.SMART_CONTRACT_EXECUTION) {
            return new KlayRawTransaction(TxTypeSmartContractExecution.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from, payload));
        }
        if (type == TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION) {
            return new KlayRawTransaction(TxTypeFeeDelegatedSmartContractExecution.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from, payload));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload, BigInteger option) {
        if (type == TxType.Type.SMART_CONTRACT_DEPLOY) {
            return new KlayRawTransaction(TxTypeSmartContractDeploy.createTransaction(chainId, type, nonce, gasPrice, gas, value, from, payload, option));
        }
        if (type == TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY) {
            return new KlayRawTransaction(TxTypeFeeDelegatedSmartContractDeploy.createTransaction(chainId, type, nonce, gasPrice, gas, value, from, payload, option));
        }
        if (type == TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedValueTransferMemoWithRatio.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from, payload, option));
        }
        if (type == TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedSmartContractExecutionWithRatio.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from, payload, option));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, AccountKey accountKey, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_ACCOUNT_UPDATE_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedAccountUpdateWithRatio.createTransaction(chainId, type, nonce, gasPrice, gas, from, accountKey, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_CANCEL_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedCancelWithRatio.createTransaction(chainId, type, nonce, gasPrice, gas, from, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedValueTransferWithRatio.createTransaction(chainId, type, nonce, gasPrice, gas, to, value, from, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String to, BigInteger value, String from, byte[] payload, BigInteger codeFormat, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedSmartContractDeployWithRatio.createTransaction(chainId, type, nonce, gasPrice, gas, value, from, payload, codeFormat, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, byte[] payload) {
        if (type == TxType.Type.CHAIN_DATA_ANCHORING) {
            return new KlayRawTransaction(TxTypeChainDataAnchoring.createTransaction(chainId, type, nonce, gasPrice, gas, from, payload));
        }
        if (type == TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING) {
            return new KlayRawTransaction(TxTypeFeeDelegatedChainDataAnchoring.createTransaction(chainId, type, nonce, gasPrice, gas, from, payload));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public static KlayRawTransaction createTransaction(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gas, String from, byte[] payload, BigInteger feeRatio) {
        if (type == TxType.Type.FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO) {
            return new KlayRawTransaction(TxTypeFeeDelegatedChainDataAnchoringWithRatio.createTransaction(chainId, type, nonce, gasPrice, gas, from, payload, feeRatio));
        }
        throw new UnsupportedOperationException("Unsupported type transaction");
    }

    public byte[] getRaw() {
        return this.value;
    }

    public KlayRawTransaction fillTransaction(Web3j web3j) throws IOException {
        KlayRawTransaction raw;
        AbstractTxType tx = (AbstractTxType)this.getTransaction();
        TxType.Type type = tx.getKlayType();
        EthChainId EthchainId = (EthChainId)web3j.ethChainId().send();
        long chainId = EthchainId.getChainId().longValue();
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)web3j.ethGetTransactionCount(tx.getFrom(), (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send();
        BigInteger nonce = ethGetTransactionCount.getTransactionCount();
        Object gasPriceResponse = ((KlayGasPriceResponse)web3j.klayGasPrice().send()).getResult();
        if (gasPriceResponse == null) {
            throw new UnsupportedOperationException("Cannot get GasPrice");
        }
        BigInteger gasPrice = new BigInteger(Numeric.cleanHexPrefix((String)((String)gasPriceResponse)), 16);
        if (!TxType.Type.isFeeDelegated(type) && !TxType.Type.isPartialFeeDelegated(type)) {
            KlayRawTransaction raw2;
            switch (type) {
                case ACCOUNT_UPDATE: {
                    raw2 = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getFrom(), ((TxTypeAccountUpdate)tx).getAccountKey());
                    break;
                }
                case CANCEL: {
                    raw2 = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getFrom());
                    break;
                }
                case SMART_CONTRACT_DEPLOY: {
                    raw2 = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeSmartContractDeploy)tx).getPayload(), ((TxTypeSmartContractDeploy)tx).getCodeFormat());
                    break;
                }
                case SMART_CONTRACT_EXECUTION: {
                    raw2 = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeSmartContractExecution)tx).getPayload());
                    break;
                }
                case VALUE_TRANSFER: {
                    raw2 = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom());
                    break;
                }
                case VALUE_TRANSFER_MEMO: {
                    raw2 = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeValueTransferMemo)tx).getPayload());
                    break;
                }
                case CHAIN_DATA_ANCHORING: {
                    raw2 = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeChainDataAnchoring)tx).getAnchoredData());
                    break;
                }
                default: {
                    raw2 = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom());
                }
            }
            return raw2;
        }
        switch (type) {
            case FEE_DELEGATED_CANCEL: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getFrom());
                break;
            }
            case FEE_DELEGATED_CANCEL_WITH_RATIO: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getFrom(), ((TxTypeFeeDelegatedCancelWithRatio)tx).getFeeRatio());
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_DEPLOY: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedSmartContractDeploy)tx).getPayload(), ((TxTypeFeeDelegatedSmartContractDeploy)tx).getCodeFormat());
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedSmartContractDeployWithRatio)tx).getPayload(), ((TxTypeFeeDelegatedSmartContractDeployWithRatio)tx).getCodeFormat(), ((TxTypeFeeDelegatedSmartContractDeployWithRatio)tx).getFeeRatio());
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_EXECUTION: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedSmartContractExecution)tx).getPayload());
                break;
            }
            case FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedSmartContractExecution)tx).getPayload(), ((TxTypeFeeDelegatedSmartContractExecution)tx).getFeeRatio());
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom());
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_MEMO: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedValueTransferMemoWithRatio)tx).getPayload());
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedValueTransferWithRatio)tx).getFeeRatio());
                break;
            }
            case FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedValueTransferMemoWithRatio)tx).getPayload(), ((TxTypeFeeDelegatedValueTransferMemoWithRatio)tx).getFeeRatio());
                break;
            }
            case FEE_DELEGATED_CHAIN_DATA_ANCHORING_WITH_RATIO: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedChainDataAnchoring)tx).getAnchoredData());
                break;
            }
            case FEE_DELEGATED_CHAIN_DATA_ANCHORING: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom(), ((TxTypeFeeDelegatedChainDataAnchoring)tx).getAnchoredData(), ((TxTypeFeeDelegatedChainDataAnchoring)tx).getFeeRatio());
                break;
            }
            default: {
                raw = KlayRawTransaction.createTransaction(chainId, type, nonce, gasPrice, tx.getGasLimit(), tx.getTo(), tx.getValue(), tx.getFrom());
            }
        }
        return raw;
    }
}

