/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayWalletUtils;
import org.web3j.example.keySample;

public class DecryptKeystoreV4Example
implements keySample {
    public static void run() throws Exception {
        String[] keyFiles;
        String password = "Iloveklaytn";
        for (String keyFile : keyFiles = new String[]{"/RoleBased_V4.json", "/Multi_V4.json", "/Public_V4.json"}) {
            String json = DecryptKeystoreV4Example.getResourceJSON(keyFile);
            List<List<KlayCredentials>> credentialsLists = KlayWalletUtils.loadJsonKlayCredentialsFromV4(password, json);
            System.out.println("Load KlayCredentials from keystore file: " + keyFile);
            for (int i = 0; i < credentialsLists.size(); ++i) {
                List<KlayCredentials> credentialsList = credentialsLists.get(i);
                System.out.println("Array " + (i + 1) + ":");
                for (KlayCredentials credentials : credentialsList) {
                    String address = credentials.getAddress();
                    String privateKey = credentials.getEcKeyPair().getPrivateKey().toString(16);
                    System.out.println("\tKlayCrendential : Address: " + address + ", Private Key: 0x" + privateKey);
                }
            }
        }
    }

    static String getResourceJSON(String resourcePath) throws IOException {
        String string;
        InputStream inputStream = DecryptKeystoreV4Example.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new IllegalArgumentException("resource not found: " + resourcePath);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return string;
    }
}

