/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.example;

import java.io.IOException;
import java.util.List;
import org.web3j.crypto.KlayCredentials;
import org.web3j.example.keySample;
import org.web3j.klayAccount.AccountStore;
import org.web3j.klayAccount.Accounts;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.klaytn.Web3j;
import org.web3j.utils.Numeric;

public class AccountStoreExample
implements keySample {
    public static void run() throws IOException {
        Web3j web3j = Web3j.build((Web3jService)new HttpService("https://public-en-baobab.klaytn.net"));
        KlayCredentials cred_legacy = KlayCredentials.create("0x0e4ca6d38096ad99324de0dde108587e5d7c600165ae4cd6c2462c597458c2b8");
        KlayCredentials cred_legacy2 = KlayCredentials.create("0x9435261ed483b6efa3886d6ad9f64c12078a0e28d8d80715c773e16fc000cff4");
        KlayCredentials cred_public = KlayCredentials.create("0x0e4ca6d38096ad99324de0dde108587e5d7c600165ae4cd6c2462c597458c2b8");
        KlayCredentials cred_multi = KlayCredentials.create("0xa32c30608667d43be2d652bede413f12a649dd1be93440878e7f712d51a6768a", "0x82c6a8d94993d49cfd0c1d30f0f8caa65782cc7e");
        KlayCredentials cred_multi_with_orig_addr = KlayCredentials.create("0xa32c30608667d43be2d652bede413f12a649dd1be93440878e7f712d51a6768a");
        KlayCredentials cred_rolebased = KlayCredentials.create("0xc9668ccd35fc20587aa37a48838b48ccc13cf14dd74c8999dd6a480212d5f7ac", "0x5bd2fb3c21564c023a4a735935a2b7a238c4ccea");
        Accounts accounts = new Accounts();
        accounts.add(cred_legacy);
        accounts.add(cred_legacy2);
        accounts.add(cred_public);
        accounts.add(cred_multi);
        accounts.add(cred_multi_with_orig_addr);
        accounts.add(cred_rolebased);
        accounts.add("0xc9668ccd35fc20587aa37a48838b48ccc13cf14dd74c8999dd6a480212d5f7ac");
        accounts.remove(cred_legacy2);
        List<KlayCredentials> result = accounts.credentialsByAddress("0xcb0eb737dfda52756495a5e08a9b37aab3b271da");
        System.out.println("Accounts list has " + result.size() + " Klaycredentials for address=0xcb0eb737dfda52756495a5e08a9b37aab3b271da");
        List<KlayCredentials> result2 = accounts.credentialsByKey(Numeric.toBigInt((String)"0xa32c30608667d43be2d652bede413f12a649dd1be93440878e7f712d51a6768a"));
        System.out.println("Accounts list has " + result2.size() + " Klaycredentials for given private key");
        List<KlayCredentials> result3 = accounts.getList();
        System.out.println("Accounts list has " + result3.size() + " Klaycredentials for all");
        AccountStore accStore = new AccountStore();
        accStore.refresh(web3j, accounts);
        System.out.println("result : \n" + accStore.getAccountInfos());
        System.out.println("result for address : 0x5bd2fb3c21564c023a4a735935a2b7a238c4ccea\n" + accStore.getAccountInfo("0x5bd2fb3c21564c023a4a735935a2b7a238c4ccea"));
    }
}

