/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.KlayCredentials;
import org.web3j.crypto.KlayRawTransaction;
import org.web3j.crypto.KlaySignatureData;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.TxType;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.BytesUtils;

public abstract class AbstractTxType
implements TxType,
ITransaction {
    private final BigInteger nonce;
    private final BigInteger gasPrice;
    private final BigInteger gasLimit;
    private final String from;
    private final String to;
    private final BigInteger value;
    private Set<KlaySignatureData> senderSignatureDataSet;
    private TxType.Type type;
    private long chainId = 0L;

    public AbstractTxType(TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, String to, BigInteger value) {
        this.type = type;
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.from = from;
        this.to = to;
        this.value = value;
        this.senderSignatureDataSet = new HashSet<KlaySignatureData>();
    }

    public AbstractTxType(long chainId, TxType.Type type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, String to, BigInteger value) {
        this.chainId = chainId;
        this.type = type;
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.from = from;
        this.to = to;
        this.value = value;
        this.senderSignatureDataSet = new HashSet<KlaySignatureData>();
    }

    protected void setSenderSignatureData(KlaySignatureData signatureData) {
        this.addSenderSignatureData(signatureData);
    }

    public KlaySignatureData getSenderSignatureData() {
        Iterator<KlaySignatureData> senderSignatureIterator = this.senderSignatureDataSet.iterator();
        if (senderSignatureIterator.hasNext()) {
            return senderSignatureIterator.next();
        }
        throw new RuntimeException("The use of `getSenderSignatureData()` is not recommended. Use `getSenderSignatureDataSet()` instead.\n");
    }

    protected void addSenderSignatureData(KlaySignatureData signatureData) {
        this.senderSignatureDataSet.add(signatureData);
    }

    public void addSenderSignatureData(Set<KlaySignatureData> senderSignatureDataSet) {
        this.senderSignatureDataSet.addAll(senderSignatureDataSet);
    }

    protected void addSenderSignatureData(List<RlpType> signatureRlpTypeList) {
        for (RlpType signature : signatureRlpTypeList) {
            List vrs = ((RlpList)signature).getValues();
            if (vrs.size() < 3) continue;
            byte[] v = ((RlpString)vrs.get(0)).getBytes();
            byte[] r = ((RlpString)vrs.get(1)).getBytes();
            byte[] s = ((RlpString)vrs.get(2)).getBytes();
            this.addSenderSignatureData(new KlaySignatureData(v, r, s));
        }
    }

    public void addSignatureData(List<RlpType> values, int offset) {
        if (values.size() > offset) {
            List senderSignatures = ((RlpList)values.get(offset)).getValues();
            this.addSenderSignatureData(senderSignatures);
        }
    }

    public void addSignatureData(AbstractTxType txType) {
        this.addSenderSignatureData(txType.getSenderSignatureDataSet());
    }

    public Set<KlaySignatureData> getSenderSignatureDataSet() {
        return this.senderSignatureDataSet;
    }

    public Set<KlaySignatureData> getNewSenderSignatureDataSet(KlayCredentials credentials, long chainId) {
        HashSet<KlaySignatureData> senderSignatureDataList = new HashSet<KlaySignatureData>();
        KlaySignatureData signatureData = KlaySignatureData.createKlaySignatureDataFromChainId(chainId);
        byte[] encodedTransaction = this.getEncodedTransactionNoSig();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte[])encodedTransaction));
        rlpTypeList.addAll(signatureData.toRlpList().getValues());
        byte[] encodedTransaction2 = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        Sign.SignatureData signedSignatureData = Sign.signMessage((byte[])encodedTransaction2, (ECKeyPair)credentials.getEcKeyPair());
        senderSignatureDataList.add(KlaySignatureData.createEip155KlaySignatureData(signedSignatureData, chainId));
        return senderSignatureDataList;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public byte[] getEncodedTransactionNoSig() {
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((byte)this.getKlayType().get()));
        rlpTypeList.addAll(this.rlpValues());
        return RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
    }

    @Override
    public List<RlpType> rlpValues() {
        ArrayList<RlpType> values = new ArrayList<RlpType>();
        values.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        values.add((RlpType)RlpString.create((BigInteger)this.getGasPrice()));
        values.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        return values;
    }

    @Override
    public KlaySignatureData getSignatureData(KlayCredentials credentials, int chainId) {
        KlaySignatureData signatureData = KlaySignatureData.createKlaySignatureDataFromChainId(chainId);
        byte[] encodedTransaction = this.getEncodedTransactionNoSig();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte[])encodedTransaction));
        rlpTypeList.addAll(signatureData.toRlpList().getValues());
        byte[] encodedTransaction2 = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        Sign.SignatureData signedSignatureData = Sign.signMessage((byte[])encodedTransaction2, (ECKeyPair)credentials.getEcKeyPair());
        return KlaySignatureData.createEip155KlaySignatureData(signedSignatureData, chainId);
    }

    @Override
    public KlayRawTransaction sign(KlayCredentials credentials, long chainId) {
        Set<KlaySignatureData> newSignatureDataSet = this.getNewSenderSignatureDataSet(credentials, chainId);
        this.addSenderSignatureData(newSignatureDataSet);
        ArrayList<RlpType> rlpTypeList = new ArrayList<RlpType>(this.rlpValues());
        ArrayList<RlpList> senderSignatureList = new ArrayList<RlpList>();
        for (KlaySignatureData klaySignatureData : this.getSenderSignatureDataSet()) {
            senderSignatureList.add(klaySignatureData.toRlpList());
        }
        rlpTypeList.add((RlpType)new RlpList(senderSignatureList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{this.getKlayType().get()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return new KlayRawTransaction((ITransaction)this, rawTx, this.getSenderSignatureData());
    }

    public long getChainId() {
        return this.chainId;
    }

    @Override
    public TxType.Type getKlayType() {
        return this.type;
    }
}

